/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;

public class LinkButtonUI
extends BasicButtonUI {
    private static MouseListener mouseListener = new mouseAdapter();
    static LinkButtonUI ui = new LinkButtonUI();
    private Color focusColor;
    private Color foregroundColor = new Color(20, 70, 175);
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        return ui;
    }

    protected void installDefaults(AbstractButton b) {
        try {
            super.installDefaults(b);
        }
        catch (Exception exception) {
            // empty catch block
        }
        b.setOpaque(false);
        b.setBorderPainted(false);
        b.setRolloverEnabled(true);
        b.setForeground(this.foregroundColor);
        this.focusColor = UIManager.getColor("ButtonUI.focus");
        b.setHorizontalAlignment(2);
    }

    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addMouseListener(mouseListener);
    }

    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.removeMouseListener(mouseListener);
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        LinkButtonUI.viewRect.x = i.left;
        LinkButtonUI.viewRect.y = i.top;
        LinkButtonUI.viewRect.width = b.getWidth() - (i.right + LinkButtonUI.viewRect.x);
        LinkButtonUI.viewRect.height = b.getHeight() - (i.bottom + LinkButtonUI.viewRect.y);
        LinkButtonUI.textRect.height = 0;
        LinkButtonUI.textRect.width = 0;
        LinkButtonUI.textRect.y = 0;
        LinkButtonUI.textRect.x = 0;
        LinkButtonUI.iconRect.height = 0;
        LinkButtonUI.iconRect.width = 0;
        LinkButtonUI.iconRect.y = 0;
        LinkButtonUI.iconRect.x = 0;
        Font f = c.getFont();
        g.setFont(f);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        this.clearTextShiftOffset();
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g, b);
        }
        if (b.getIcon() != null) {
            this.paintIcon(g, c, iconRect);
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
        if (model.isRollover()) {
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(10, 0.6f));
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (model.isRollover()) {
            g.drawLine((int)textRect.getX(), (int)(textRect.getY() + textRect.getHeight() - 2.0), (int)(textRect.getX() + textRect.getWidth()), (int)(textRect.getY() + textRect.getHeight() - 2.0));
        }
    }

    static Color getLighter(Color c) {
        return c.brighter();
    }

    protected int getTextShiftOffset() {
        return 0;
    }

    static class mouseAdapter
    extends MouseAdapter {
        mouseAdapter() {
        }

        public void mouseEntered(MouseEvent e) {
            e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            ((JComponent)e.getSource()).repaint();
        }

        public void mouseExited(MouseEvent e) {
            e.getComponent().setCursor(Cursor.getDefaultCursor());
            ((JComponent)e.getSource()).repaint();
        }
    }
}

