/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.plugin;

import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.gui.dialog.AboutBox;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.OperatorService;
import edu.udo.cs.yale.tools.ParameterService;
import edu.udo.cs.yale.tools.ResourceSource;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.plugin.Dependency;
import edu.udo.cs.yale.tools.plugin.PluginClassLoader;
import java.awt.Frame;
import java.awt.Image;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class Plugin {
    private JarFile archive;
    private PluginClassLoader classLoader;
    private String name;
    private String version;
    private String vendor;
    private String url;
    private String neededYaleVersion = "0";
    private List<Dependency> pluginDependencies = new LinkedList<Dependency>();
    private static List<Plugin> allPlugins = new LinkedList<Plugin>();

    public Plugin(File file) throws IOException {
        this.archive = new JarFile(file);
        URL url = new URL("file", null, file.getAbsolutePath());
        this.classLoader = new PluginClassLoader(new URL[]{url});
        Tools.addResourceSource(new ResourceSource(this.classLoader));
        this.getMetaData();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getNeededYaleVersion() {
        return this.neededYaleVersion;
    }

    public List getPluginDependencies() {
        return this.pluginDependencies;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private boolean checkDependencies(List plugins) {
        if (Yale.getVersion().compareTo(this.neededYaleVersion) < 0) {
            return false;
        }
        for (Dependency dependency : this.pluginDependencies) {
            if (dependency.isFulfilled(plugins)) continue;
            return false;
        }
        return true;
    }

    private void getMetaData() {
        try {
            String dependencies;
            Attributes atts = this.archive.getManifest().getMainAttributes();
            this.name = atts.getValue("Implementation-Title");
            if (this.name == null) {
                this.name = this.archive.getName();
            }
            this.version = atts.getValue("Implementation-Version");
            if (this.version == null) {
                this.version = "";
            }
            this.url = atts.getValue("Implementation-URL");
            this.vendor = atts.getValue("Implementation-Vendor");
            this.neededYaleVersion = atts.getValue("Yale-Version");
            if (this.neededYaleVersion == null) {
                this.neededYaleVersion = "0";
            }
            if ((dependencies = atts.getValue("Plugin-Dependencies")) == null) {
                dependencies = "";
            }
            this.addDependencies(dependencies);
            Yale.splashMessage("Loading " + this.name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addDependencies(String dependencies) {
        String[] singleDependencies = dependencies.trim().split("#");
        int i = 0;
        while (i < singleDependencies.length) {
            if (singleDependencies[i].trim().length() > 0) {
                String dependencyName = singleDependencies[i].trim();
                String dependencyVersion = "0";
                if (singleDependencies[i].trim().indexOf("[") > 0) {
                    dependencyName = singleDependencies[i].trim().substring(0, singleDependencies[i].trim().indexOf("[")).trim();
                    dependencyVersion = singleDependencies[i].trim().substring(singleDependencies[i].trim().indexOf("[") + 1, singleDependencies[i].trim().indexOf("]")).trim();
                }
                this.pluginDependencies.add(new Dependency(dependencyName, dependencyVersion));
            }
            ++i;
        }
    }

    public void register() {
        URL operatorsURL = this.classLoader.getResource("META-INF/operators.xml");
        if (operatorsURL == null && (operatorsURL = this.classLoader.getResource("operators.xml")) != null) {
            LogService.logMessage(String.valueOf(this.name) + ": putting operators.xml in root directory of jar is deprecated. Use META-INF directory instead!", 4);
        }
        if (operatorsURL == null) {
            LogService.logMessage("Plugin '" + this.archive.getName() + "' does not contain operators.xml!", 6);
        } else {
            Iterator<Dependency> i = this.pluginDependencies.iterator();
            while (i.hasNext()) {
                String pluginName = i.next().getPluginName();
                Plugin other = Plugin.getPlugin(pluginName);
                this.mergeClassLoader(other);
            }
            InputStream in = null;
            try {
                in = operatorsURL.openStream();
            }
            catch (IOException e) {
                LogService.logMessage("Cannot read operators.xml from '" + this.archive.getName() + "'!", 6);
            }
            LogService.logMessage("Loading " + this.name, 3);
            OperatorService.registerOperators(this.archive.getName(), in, this.classLoader, true);
        }
    }

    public AboutBox createAboutBox(Frame owner) {
        String about = "";
        try {
            URL url = this.classLoader.getResource("META-INF/ABOUT.NFO");
            if (url != null) {
                about = Tools.readTextFile(new InputStreamReader(url.openStream()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new AboutBox(owner, this.name, this.version, "Vendor: " + (this.vendor != null ? this.vendor : "unknown") + Tools.getLineSeparator() + "URL: " + (this.url != null ? this.url : "unknown") + Tools.getLineSeparator() + Tools.getLineSeparator() + about, new Image[0]);
    }

    public static void findPlugins() {
        File pluginDir = ParameterService.getPluginDir();
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            return;
        }
        File[] files = pluginDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        allPlugins = new LinkedList<Plugin>();
        int i = 0;
        while (i < files.length) {
            try {
                allPlugins.add(new Plugin(files[i]));
            }
            catch (Throwable e) {
                LogService.logException("Cannot load plugin '" + files[i] + "'", null, e);
            }
            ++i;
        }
    }

    protected void mergeClassLoader(Plugin other) {
        URL[] otherURLs = other.classLoader.getURLs();
        int i = 0;
        while (i < otherURLs.length) {
            this.classLoader.addDependingURL(otherURLs[i]);
            ++i;
        }
    }

    public String toString() {
        return String.valueOf(this.name) + " " + this.version + " (" + this.archive.getName() + ") depending on " + this.pluginDependencies;
    }

    public static void registerAllPlugins() {
        Plugin.findPlugins();
        Iterator<Plugin> i = allPlugins.iterator();
        while (i.hasNext()) {
            Plugin plugin = i.next();
            if (plugin.checkDependencies(allPlugins)) continue;
            LogService.logMessage("Cannot register operators from '" + plugin.getName() + "': Dependencies not fulfilled! This plugin need Yale version " + plugin.getNeededYaleVersion() + " and the following plugins:" + Tools.getLineSeparator() + plugin.getPluginDependencies(), 6);
            i.remove();
        }
        if (allPlugins.size() > 0) {
            LogService.logMessage("Found " + allPlugins.size() + " plugins in " + ParameterService.getPluginDir(), 3);
            i = allPlugins.iterator();
            while (i.hasNext()) {
                i.next().register();
            }
        }
    }

    public static List getAllPlugins() {
        return allPlugins;
    }

    public static Plugin getPlugin(String name) {
        for (Plugin plugin : allPlugins) {
            if (!plugin.getName().equals(name)) continue;
            return plugin;
        }
        return null;
    }
}

