/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math.som;

import edu.udo.cs.yale.tools.math.som.AdaptionFunction;

public class RitterAdaption
implements AdaptionFunction {
    private double learnRateStart = 0.8;
    private double learnRateEnd = 0.01;
    private double adaptionRadiusStart = 5.0;
    private double adaptionRadiusEnd = 1.0;
    private int lastTime = -1;
    private double learnRateCurrent;
    private double adaptionRadiusCurrent;

    public double[] adapt(double[] stimulus, double[] nodeValue, double distanceFromImpact, int time, int maxtime) {
        if (this.lastTime != time) {
            this.lastTime = time;
            this.learnRateCurrent = this.learnRateStart * Math.pow(this.learnRateEnd / this.learnRateStart, (double)time / (double)maxtime);
            this.adaptionRadiusCurrent = this.getAdaptionRadius(time, maxtime);
        }
        double distanceWeightCurrent = Math.exp(-Math.pow(distanceFromImpact, 2.0) / (2.0 * Math.pow(this.adaptionRadiusCurrent, 2.0)));
        double[] weightNew = (double[])nodeValue.clone();
        if (distanceWeightCurrent > 0.5) {
            int i = 0;
            while (i < weightNew.length) {
                int n = i;
                weightNew[n] = weightNew[n] + this.learnRateCurrent * distanceWeightCurrent * (stimulus[i] - nodeValue[i]);
                if (weightNew[i] > 10.0) {
                    weightNew[i] = weightNew[i];
                }
                ++i;
            }
        }
        return weightNew;
    }

    public double getAdaptionRadius(double[] stimulus, int time, int maxtime) {
        return this.getAdaptionRadius(time, maxtime);
    }

    private double getAdaptionRadius(int time, int maxtime) {
        return this.adaptionRadiusStart * Math.pow(this.adaptionRadiusEnd / this.adaptionRadiusStart, (double)time / (double)maxtime);
    }

    public void setAdaptionRadiusStart(double start) {
        this.adaptionRadiusStart = start;
    }

    public void setAdaptionRadiusEnd(double end) {
        this.adaptionRadiusEnd = end;
    }

    public void setLearnRateStart(double start) {
        this.learnRateStart = start;
    }

    public void setLearnRateEnd(double end) {
        this.learnRateEnd = end;
    }
}

