/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math.som;

import edu.udo.cs.yale.tools.math.som.AdaptionFunction;
import edu.udo.cs.yale.tools.math.som.DistanceFunction;
import edu.udo.cs.yale.tools.math.som.EuclideanDistance;
import edu.udo.cs.yale.tools.math.som.KohonenNode;
import edu.udo.cs.yale.tools.math.som.KohonenTrainingsData;
import edu.udo.cs.yale.tools.math.som.ProgressListener;
import edu.udo.cs.yale.tools.math.som.RitterAdaption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class KohonenNet
extends Thread {
    private long randomSeed = 19091982L;
    private int netDimension;
    private int[] netDimensions;
    private int phase;
    private int trainingSteps = 80;
    private ArrayList<ProgressListener> progressListener = new ArrayList();
    private KohonenNode[] nodes;
    private DistanceFunction distanceFunction;
    private AdaptionFunction adaptionFunction;
    private KohonenTrainingsData data;
    private Random randomGenerator = new Random(this.randomSeed);
    private int cubeNodeCounter = 0;
    private int cubeEdgeLength = 0;
    private int[] cubeEdgeLengths;
    private int[] cubeOffset;

    public KohonenNet(KohonenTrainingsData data) {
        this.distanceFunction = new EuclideanDistance();
        this.adaptionFunction = new RitterAdaption();
        this.data = data;
    }

    public void init(int dataDimension, int[] netDimensions, boolean hexagonal) {
        this.updateProgressListener(0);
        this.netDimension = netDimensions.length;
        this.netDimensions = netDimensions;
        int nodeNumber = 1;
        int i = 0;
        while (i < this.netDimension) {
            nodeNumber *= netDimensions[i];
            ++i;
        }
        this.nodes = new KohonenNode[nodeNumber];
        double[] randomTupel = new double[dataDimension];
        int i2 = 0;
        while (i2 < this.nodes.length) {
            int j = 0;
            while (j < dataDimension) {
                randomTupel[j] = this.randomGenerator.nextDouble();
                ++j;
            }
            this.nodes[i2] = new KohonenNode(randomTupel);
            ++i2;
        }
        this.phase = 1;
        this.updateProgressListener(10);
    }

    public void run() {
        this.train();
    }

    public void train() {
        if (this.phase == 1) {
            this.data.setRandomGenerator(this.randomGenerator);
            int step = 1;
            while (step <= this.trainingSteps) {
                this.updateProgressListener(10 + (step - 1) * 80 / this.trainingSteps);
                this.data.reset();
                int fittingNode = 0;
                int example = 0;
                while (example < this.data.countData()) {
                    double[] exampleWeights = this.data.getNext();
                    fittingNode = this.getBestFittingNode(exampleWeights);
                    int[] stimulusCoords = this.getCoordinatesOfIndex(fittingNode);
                    int range = 2 * (int)Math.round(this.adaptionFunction.getAdaptionRadius(null, step, this.trainingSteps));
                    this.cube(range, stimulusCoords);
                    while (this.cubeHasNext()) {
                        int currentNode = this.cubeNext();
                        double currentDistance = this.distanceFunction.getDistance(stimulusCoords, this.getCoordinatesOfIndex(currentNode), this.netDimensions);
                        this.nodes[currentNode].setWeights(this.adaptionFunction.adapt(exampleWeights, this.nodes[currentNode].getWeights(), currentDistance, step, this.trainingSteps));
                    }
                    ++example;
                }
                ++step;
            }
            this.phase = 2;
            this.updateProgressListener(90);
            this.informProgressExit();
        }
    }

    private boolean cubeHasNext() {
        return (double)this.cubeNodeCounter < Math.pow(this.cubeEdgeLength, this.netDimension);
    }

    private int cubeNext() {
        if ((double)this.cubeNodeCounter < Math.pow(this.cubeEdgeLength, this.netDimension)) {
            int[] coordModifier = this.getCoordinatesOfIndex(this.cubeNodeCounter, this.cubeEdgeLengths);
            coordModifier = this.addArray(coordModifier, -this.cubeEdgeLength / 2);
            int[] currentCoord = this.addArrays(coordModifier, this.cubeOffset);
            ++this.cubeNodeCounter;
            return this.getIndexOfCoordinates(currentCoord);
        }
        return -1;
    }

    private void cube(int cubeEdgeLength, int[] offset) {
        this.cubeEdgeLengths = this.setArray(new int[this.netDimension], cubeEdgeLength);
        this.cubeEdgeLength = cubeEdgeLength;
        this.cubeOffset = offset;
        this.cubeNodeCounter = 0;
    }

    public int[] apply(double[] data) {
        if (this.phase == 2) {
            int bestNode = this.getBestFittingNode(data);
            return this.getCoordinatesOfIndex(bestNode);
        }
        return new int[0];
    }

    public void setRandomSeed(long seed) {
        if (this.phase == 0) {
            this.randomSeed = seed;
        }
    }

    public void setDistanceFunction(DistanceFunction function) {
        if (this.phase == 0) {
            this.distanceFunction = function;
        }
    }

    public void setAdaptionFunction(AdaptionFunction function) {
        if (this.phase == 0) {
            this.adaptionFunction = function;
        }
    }

    public void setTrainingRounds(int rounds) {
        this.trainingSteps = Math.max(rounds, 1);
    }

    public double getDistance(double[] point1, double[] point2) {
        return this.distanceFunction.getDistance(point1, point2);
    }

    public double[] getNodeWeights(int[] coords) {
        return this.nodes[this.getIndexOfCoordinates(coords)].getWeights();
    }

    public double getNodeDistance(int nodeIndex) {
        this.cube(3, this.getCoordinatesOfIndex(nodeIndex));
        double distance = 0.0;
        while (this.cubeHasNext()) {
            distance += this.distanceFunction.getDistance(this.nodes[nodeIndex].getWeights(), this.nodes[this.cubeNext()].getWeights());
        }
        return distance;
    }

    private int getBestFittingNode(double[] dataVector) {
        double bestDistance = Double.POSITIVE_INFINITY;
        int best = -1;
        int i = 0;
        while (i < this.nodes.length) {
            double currentDistance = this.distanceFunction.getDistance(dataVector, this.nodes[i].getWeights());
            if (currentDistance < bestDistance) {
                best = i;
                bestDistance = currentDistance;
            }
            ++i;
        }
        return best;
    }

    private int[] getCoordinatesOfIndex(int index, int[] dimensions) {
        int[] coordinate = new int[dimensions.length];
        int i = 0;
        while (i < dimensions.length) {
            coordinate[i] = index % dimensions[i];
            index /= dimensions[i];
            ++i;
        }
        return coordinate;
    }

    private int[] getCoordinatesOfIndex(int index) {
        return this.getCoordinatesOfIndex(index, this.netDimensions);
    }

    public int getIndexOfCoordinates(int[] coordinates) {
        return this.getIndexOfCoordinates(coordinates, this.netDimensions);
    }

    private int getIndexOfCoordinates(int[] coordinates, int[] dimensions) {
        int index = 0;
        int i = dimensions.length - 1;
        while (i >= 0) {
            if (coordinates[i] < 0) {
                coordinates[i] = dimensions[i] + coordinates[i];
            }
            index *= dimensions[i];
            index += Math.abs(coordinates[i] % dimensions[i]);
            --i;
        }
        return index;
    }

    private int[] addArrays(int[] array, int[] adder) {
        if (array.length == adder.length) {
            int i = 0;
            while (i < array.length) {
                int n = i;
                array[n] = array[n] + adder[i];
                ++i;
            }
        }
        return array;
    }

    private int[] addArray(int[] array, int adder) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] + adder;
        }
        return array;
    }

    private int[] setArray(int[] array, int value) {
        int i = 0;
        while (i < array.length) {
            array[i] = value;
            ++i;
        }
        return array;
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListener.add(listener);
    }

    public void updateProgressListener(int value) {
        Iterator<ProgressListener> iterator = this.progressListener.iterator();
        while (iterator.hasNext()) {
            iterator.next().setProgress(value);
        }
    }

    public void informProgressExit() {
        Iterator<ProgressListener> iterator = this.progressListener.iterator();
        while (iterator.hasNext()) {
            iterator.next().progressFinished();
        }
    }
}

