/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math.som;

import edu.udo.cs.yale.tools.math.som.DistanceFunction;

public class EuclideanDistance
implements DistanceFunction {
    public double getDistance(double[] point1, double[] point2) {
        double distance = 0.0;
        int i = 0;
        while (i < point1.length) {
            distance += Math.pow(point1[i] - point2[i], 2.0);
            ++i;
        }
        distance = Math.sqrt(distance);
        return distance;
    }

    public double getDistance(int[] point1, int[] point2) {
        double distance = 0.0;
        int i = 0;
        while (i < point1.length) {
            distance += Math.pow(point1[i] - point2[i], 2.0);
            ++i;
        }
        distance = Math.sqrt(distance);
        return distance;
    }

    public double getDistance(int[] point1, int[] point2, int[] dimensions) {
        double distance = 0.0;
        int i = 0;
        while (i < point1.length) {
            int coord1 = point1[i] < 0 ? dimensions[i] + point1[i] : point1[i];
            int coord2 = point2[i] < 0 ? dimensions[i] + point2[i] : point2[i];
            distance += Math.pow(Math.min(Math.abs(coord1 - coord2), (coord1 + dimensions[i] - coord2) % dimensions[i]), 2.0);
            ++i;
        }
        distance = Math.sqrt(distance);
        return distance;
    }
}

