/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math.optimization.ec.pso;

import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.RandomGenerator;
import edu.udo.cs.yale.tools.math.optimization.Optimization;
import edu.udo.cs.yale.tools.math.optimization.ec.pso.Population;

public abstract class PSOOptimization
implements Optimization {
    private int maxGen;
    private int maxWithoutImprovement;
    private double inertiaWeight;
    private double localWeight;
    private double globalWeight;
    private double minValue;
    private double maxValue;
    private double inertiaWeightDelta;
    private RandomGenerator random;
    private Population population;

    public PSOOptimization(int popSize, int individualSize, int maxGen, int maxWithoutImprovement, double inertiaWeight, double localWeight, double globalWeight, double minValue, double maxValue, boolean dynamicInertiaWeight, RandomGenerator random) {
        this.maxGen = maxGen;
        this.maxWithoutImprovement = maxWithoutImprovement;
        if (this.maxWithoutImprovement < 1) {
            this.maxWithoutImprovement = this.maxGen;
        }
        this.inertiaWeight = inertiaWeight;
        this.localWeight = localWeight;
        this.globalWeight = globalWeight;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.inertiaWeightDelta = 0.0;
        if (dynamicInertiaWeight) {
            this.inertiaWeightDelta = inertiaWeight / (double)maxGen;
        }
        this.random = random;
        this.population = this.createInitialPopulation(popSize, individualSize);
    }

    public abstract PerformanceVector evaluateIndividual(double[] var1) throws OperatorException;

    public void nextIteration() throws OperatorException {
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    protected Population createInitialPopulation(int popSize, int individualSize) {
        Population initPop = new Population(popSize, individualSize);
        int i = 0;
        while (i < popSize) {
            double[] values = new double[individualSize];
            int j = 0;
            while (j < values.length) {
                values[j] = this.random.nextDoubleInRange(this.minValue, this.maxValue);
                ++j;
            }
            initPop.setValues(i, values);
            ++i;
        }
        return initPop;
    }

    public void optimize() throws OperatorException {
        double[][] velocities = new double[this.population.getNumberOfIndividuals()][this.population.getIndividualSize()];
        int p = 0;
        while (p < velocities.length) {
            int a = 0;
            while (a < velocities[p].length) {
                velocities[p][a] = 0.0;
                ++a;
            }
            ++p;
        }
        this.evaluate(this.population);
        this.population.nextGeneration();
        this.nextIteration();
        while (this.population.getGeneration() < this.maxGen && this.population.getGenerationsWithoutImprovement() < this.maxWithoutImprovement && !(this.population.getBestFitnessEver() >= this.population.getBestPerformanceEver().getMainCriterion().getMaxFitness())) {
            int d;
            double[] globalBest = this.population.getGlobalBestValues();
            int i = 0;
            while (i < velocities.length) {
                double[] localBest = this.population.getLocalBestValues(i);
                double[] current = this.population.getValues(i);
                d = 0;
                while (d < velocities[i].length) {
                    velocities[i][d] = this.inertiaWeight * velocities[i][d] + this.localWeight * (this.random.nextGaussian() + 1.0) * (localBest[d] - current[d]) + this.globalWeight * (this.random.nextGaussian() + 1.0) * (globalBest[d] - current[d]);
                    ++d;
                }
                ++i;
            }
            i = 0;
            while (i < velocities.length) {
                double[] current = this.population.getValues(i);
                double[] newValues = new double[current.length];
                d = 0;
                while (d < velocities[i].length) {
                    newValues[d] = current[d] + velocities[i][d];
                    if (newValues[d] < this.minValue) {
                        newValues[d] = this.minValue;
                    }
                    if (newValues[d] > this.maxValue) {
                        newValues[d] = this.maxValue;
                    }
                    ++d;
                }
                this.population.setValues(i, newValues);
                ++i;
            }
            this.inertiaWeight -= this.inertiaWeightDelta;
            this.evaluate(this.population);
            this.population.nextGeneration();
            this.nextIteration();
        }
    }

    private void evaluate(Population population) throws OperatorException {
        PerformanceVector[] fitnessValues = new PerformanceVector[population.getNumberOfIndividuals()];
        int i = 0;
        while (i < fitnessValues.length) {
            double[] individual = population.getValues(i);
            fitnessValues[i] = this.evaluateIndividual(individual);
            ++i;
        }
        population.setFitnessVector(fitnessValues);
    }

    public int getGeneration() {
        return this.population.getGeneration();
    }

    public double getBestFitnessInGeneration() {
        return this.population.getBestFitnessInGeneration();
    }

    public double getBestFitnessEver() {
        return this.population.getBestFitnessEver();
    }

    public PerformanceVector getBestPerformanceEver() {
        return this.population.getBestPerformanceEver();
    }

    public double[] getBestValuesEver() {
        return this.population.getGlobalBestValues();
    }
}

