/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math.optimization.ec.es;

import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.math.optimization.ec.es.GaussianMutation;
import edu.udo.cs.yale.tools.math.optimization.ec.es.Population;
import edu.udo.cs.yale.tools.math.optimization.ec.es.PopulationOperator;
import java.util.Iterator;
import java.util.LinkedList;

public class VarianceAdaption
implements PopulationOperator {
    private static final int WAIT_INTERVALS = 2;
    private static final double FACTOR = 0.85;
    private GaussianMutation mutation = null;
    private int intervalSize;
    private LinkedList<Boolean> successList = new LinkedList();

    public VarianceAdaption(GaussianMutation mutation, int intervalSize) {
        this.mutation = mutation;
        this.intervalSize = intervalSize;
    }

    public void operate(Population population) {
        if (population.getGenerationsWithoutImprovement() < 2) {
            this.successList.add(true);
        } else {
            this.successList.add(false);
        }
        if (population.getGeneration() >= 2 * this.intervalSize) {
            this.successList.removeFirst();
            if (population.getGeneration() % this.intervalSize == 0) {
                int successCount = 0;
                Iterator i = this.successList.iterator();
                while (i.hasNext()) {
                    if (!((Boolean)i.next()).booleanValue()) continue;
                    ++successCount;
                }
                if ((double)successCount / (double)(2 * this.intervalSize) < 0.2) {
                    double[] sigma = this.mutation.getSigma();
                    int s = 0;
                    while (s < sigma.length) {
                        int n = s++;
                        sigma[n] = sigma[n] * 0.85;
                    }
                    this.mutation.setSigma(sigma);
                    LogService.logMessage("Applying 1/5-rule: shrink variance!", 2);
                } else {
                    double[] sigma = this.mutation.getSigma();
                    int s = 0;
                    while (s < sigma.length) {
                        int n = s++;
                        sigma[n] = sigma[n] / 0.85;
                    }
                    this.mutation.setSigma(sigma);
                    LogService.logMessage("Applying 1/5-rule: enlarge variance!", 2);
                }
            }
        }
    }
}

