/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math.optimization.ec.es;

import edu.udo.cs.yale.tools.math.optimization.ec.es.Individual;
import edu.udo.cs.yale.tools.math.optimization.ec.es.Population;
import edu.udo.cs.yale.tools.math.optimization.ec.es.PopulationOperator;
import java.util.LinkedList;
import java.util.Random;

public class SwitchingMutation
implements PopulationOperator {
    private double prob;
    private double[] min;
    private double[] max;
    private int[] valueTypes;
    private Random random;

    public SwitchingMutation(double prob, double[] min, double[] max, int[] valueTypes, Random random) {
        this.prob = prob;
        this.min = min;
        this.max = max;
        this.valueTypes = valueTypes;
        this.random = random;
    }

    public void operate(Population population) {
        LinkedList<Individual> newIndividuals = new LinkedList<Individual>();
        int i = 0;
        while (i < population.getNumberOfIndividuals()) {
            Individual clone = (Individual)population.get(i).clone();
            double[] values = clone.getValues();
            boolean changed = false;
            int j = 0;
            while (j < values.length) {
                if (this.random.nextDouble() < this.prob) {
                    changed = true;
                    values[j] = values[j] != this.min[j] ? this.min[j] : this.max[j];
                    if (this.valueTypes[j] == 1) {
                        values[j] = (int)Math.round(values[j]);
                    }
                }
                ++j;
            }
            if (changed) {
                clone.setValues(values);
                newIndividuals.add(clone);
            }
            ++i;
        }
        population.addAll(newIndividuals);
    }
}

