/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math.optimization.ec.es;

import edu.udo.cs.yale.tools.math.optimization.ec.es.Individual;
import edu.udo.cs.yale.tools.math.optimization.ec.es.Population;
import edu.udo.cs.yale.tools.math.optimization.ec.es.PopulationOperator;
import java.util.LinkedList;
import java.util.Random;

public class StochasticUniversalSampling
implements PopulationOperator {
    private int popSize;
    private boolean keepBest;
    private Random random;

    public StochasticUniversalSampling(int popSize, boolean keepBest, Random random) {
        this.popSize = popSize;
        this.keepBest = keepBest;
        this.random = random;
    }

    public boolean performOperation(int generation) {
        return true;
    }

    public double filterFitness(double fitness) {
        return fitness;
    }

    public void operate(Population population) {
        LinkedList<Individual> newGeneration = new LinkedList<Individual>();
        if (this.keepBest) {
            newGeneration.add(population.getBestEver());
        }
        int numberOfMarks = this.popSize - newGeneration.size();
        double distance = 1.0 / (double)numberOfMarks;
        double r = this.random.nextDouble() / (double)numberOfMarks;
        int i = 0;
        while (i < numberOfMarks) {
            double f = 0.0;
            int j = 0;
            Individual individual = null;
            while ((f += this.filterFitness((individual = population.get(j++)).getFitness().getMainCriterion().getFitness())) < r) {
            }
            newGeneration.add(individual);
            r += distance;
            ++i;
        }
        population.clear();
        population.addAll(newGeneration);
    }
}

