/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math.optimization.ec.es;

import edu.udo.cs.yale.datatable.SimpleDataTable;
import edu.udo.cs.yale.datatable.SimpleDataTableRow;
import edu.udo.cs.yale.gui.plotter.SimplePlotterDialog;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.math.optimization.ec.es.Population;
import edu.udo.cs.yale.tools.math.optimization.ec.es.PopulationOperator;

public class PopulationPlotter
implements PopulationOperator {
    private SimplePlotterDialog plotter = null;
    private SimpleDataTable criteriaDataTable = null;

    public void operate(Population pop) {
        if (pop.getNumberOfIndividuals() == 0) {
            return;
        }
        if (this.criteriaDataTable == null) {
            this.criteriaDataTable = this.createDataTable(pop);
        }
        int numberOfCriteria = this.fillDataTable(this.criteriaDataTable, pop);
        if (this.plotter == null) {
            this.plotter = new SimplePlotterDialog(this.criteriaDataTable, false);
            if (numberOfCriteria == 1) {
                this.plotter.setXAxis(0);
                this.plotter.plotColumn(0, true);
            } else if (numberOfCriteria == 2) {
                this.plotter.setXAxis(0);
                this.plotter.plotColumn(1, true);
            } else if (numberOfCriteria > 2) {
                this.plotter.setXAxis(0);
                this.plotter.setYAxis(1);
                this.plotter.plotColumn(2, true);
            }
            this.plotter.setDraw2DLines(false);
            this.plotter.setVisible(true);
        }
    }

    public SimpleDataTable createDataTable(Population pop) {
        double[] prototype = pop.get(0).getFitnessValues();
        String[] names = new String[prototype.length];
        int i = 0;
        while (i < names.length) {
            names[i] = "criterion" + i;
            ++i;
        }
        SimpleDataTable dataTable = new SimpleDataTable("Population", names);
        return dataTable;
    }

    public int fillDataTable(SimpleDataTable dataTable, Population pop) {
        dataTable.clear();
        int numberOfCriteria = 0;
        int i = 0;
        while (i < pop.getNumberOfIndividuals()) {
            String id = String.valueOf(i) + " (";
            double[] currentFitness = pop.get(i).getFitnessValues();
            numberOfCriteria = Math.max(numberOfCriteria, currentFitness.length);
            double[] data = new double[currentFitness.length];
            int d = 0;
            while (d < data.length) {
                data[d] = currentFitness[d];
                if (d != 0) {
                    id = String.valueOf(id) + ", ";
                }
                id = String.valueOf(id) + Tools.formatNumber(data[d]);
                ++d;
            }
            id = String.valueOf(id) + ")";
            dataTable.add(new SimpleDataTableRow(data, id));
            ++i;
        }
        return numberOfCriteria;
    }
}

