/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math.optimization.ec.es;

import edu.udo.cs.yale.tools.math.optimization.ec.es.Individual;
import edu.udo.cs.yale.tools.math.optimization.ec.es.Population;
import edu.udo.cs.yale.tools.math.optimization.ec.es.PopulationOperator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonDominatedSortingSelection
implements PopulationOperator {
    private int popSize;

    public NonDominatedSortingSelection(int popSize) {
        this.popSize = popSize;
    }

    @Override
    public void operate(Population population) {
        ArrayList<List<Individual>> ranks = new ArrayList<List<Individual>>();
        while (population.getNumberOfIndividuals() > 0) {
            List<Individual> rank = this.getNextRank(population);
            ranks.add(rank);
            Iterator<Individual> i = rank.iterator();
            while (i.hasNext()) {
                population.remove(i.next());
            }
        }
        population.clear();
        int index = 0;
        while (index < ranks.size() && population.getNumberOfIndividuals() + ((List)ranks.get(index)).size() <= this.popSize) {
            population.addAll((Collection)ranks.get(index));
            ++index;
        }
        if (population.getNumberOfIndividuals() < this.popSize) {
            List rank = (List)ranks.get(index);
            this.sortByCrowdingDistance(rank);
            while (population.getNumberOfIndividuals() < this.popSize) {
                population.add((Individual)rank.remove(0));
            }
        }
    }

    private void sortByCrowdingDistance(List<Individual> rank) {
        Iterator<Individual> f = rank.iterator();
        int numberOfCriteria = 0;
        while (f.hasNext()) {
            Individual current = f.next();
            current.setCrowdingDistance(0.0);
            numberOfCriteria = Math.max(numberOfCriteria, current.getFitnessValues().length);
        }
        int m = 0;
        while (m < numberOfCriteria) {
            CriteriaComparator comparator = new CriteriaComparator(m);
            Collections.sort(rank, comparator);
            rank.get(0).setCrowdingDistance(Double.POSITIVE_INFINITY);
            rank.get(rank.size() - 1).setCrowdingDistance(Double.POSITIVE_INFINITY);
            int i = 1;
            while (i < rank.size() - 1) {
                Individual current = rank.get(i);
                double currentCrowdingDistance = current.getCrowdingDistance();
                Individual afterI = rank.get(i + 1);
                Individual beforeI = rank.get(i - 1);
                double afterPerformance = afterI.getFitnessValues()[m];
                double beforePerformance = beforeI.getFitnessValues()[m];
                current.setCrowdingDistance(currentCrowdingDistance + Math.abs(afterPerformance - beforePerformance));
                ++i;
            }
            ++m;
        }
        Collections.sort(rank, new CrowdingComparator());
    }

    private List<Individual> getNextRank(Population population) {
        ArrayList<Individual> rank = new ArrayList<Individual>();
        int i = 0;
        while (i < population.getNumberOfIndividuals()) {
            Individual current = population.get(i);
            rank.add(current);
            boolean delete = false;
            int j = rank.size() - 2;
            while (j >= 0) {
                Individual ranked = (Individual)rank.get(j);
                if (NonDominatedSortingSelection.isDominated(ranked, current)) {
                    rank.remove(ranked);
                }
                if (NonDominatedSortingSelection.isDominated(current, ranked)) {
                    delete = true;
                }
                --j;
            }
            if (delete) {
                rank.remove(current);
            }
            ++i;
        }
        return rank;
    }

    public static boolean isDominated(Individual i1, Individual i2) {
        double[] f1 = i1.getFitnessValues();
        double[] f2 = i2.getFitnessValues();
        double[][] performances = new double[f1.length][2];
        int p = 0;
        while (p < performances.length) {
            performances[p][0] = f1[p];
            performances[p][1] = f2[p];
            ++p;
        }
        boolean dominated = true;
        int p2 = 0;
        while (p2 < performances.length) {
            dominated &= performances[p2][1] >= performances[p2][0];
            ++p2;
        }
        boolean oneActuallyBetter = false;
        int p3 = 0;
        while (p3 < performances.length) {
            oneActuallyBetter |= performances[p3][1] > performances[p3][0];
            ++p3;
        }
        return dominated &= oneActuallyBetter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CriteriaComparator
    implements Comparator<Individual>,
    Serializable {
        private static final long serialVersionUID = -959843514627041473L;
        private int m;

        public CriteriaComparator(int m) {
            this.m = m;
        }

        @Override
        public int compare(Individual i1, Individual i2) {
            double[] f1 = i1.getFitnessValues();
            double[] f2 = i2.getFitnessValues();
            return -1 * Double.compare(f1[this.m], f2[this.m]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CrowdingComparator
    implements Comparator<Individual>,
    Serializable {
        private static final long serialVersionUID = -3430652527261319675L;

        private CrowdingComparator() {
        }

        @Override
        public int compare(Individual i1, Individual i2) {
            double cd1 = i1.getCrowdingDistance();
            double cd2 = i2.getCrowdingDistance();
            return -1 * Double.compare(cd1, cd2);
        }
    }
}

