/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math.optimization.ec.es;

import edu.udo.cs.yale.operator.performance.PerformanceVector;

public class Individual
implements Cloneable {
    private double[] values;
    private PerformanceVector fitness;
    private double crowdingDistance;

    public Individual(double[] values) {
        this.values = values;
    }

    public Object clone() {
        double[] alphaClone = new double[this.values.length];
        System.arraycopy(this.values, 0, alphaClone, 0, this.values.length);
        Individual clone = new Individual(alphaClone);
        return clone;
    }

    public void setCrowdingDistance(double cd) {
        this.crowdingDistance = cd;
    }

    public double getCrowdingDistance() {
        return this.crowdingDistance;
    }

    public double[] getValues() {
        return this.values;
    }

    public void setValues(double[] values) {
        this.values = values;
    }

    public double[] getFitnessValues() {
        double[] fitnessValues = new double[this.fitness.getSize()];
        int i = 0;
        while (i < fitnessValues.length) {
            fitnessValues[i] = this.fitness.getCriterion(i).getFitness();
            ++i;
        }
        return fitnessValues;
    }

    public PerformanceVector getFitness() {
        return this.fitness;
    }

    public void setFitness(PerformanceVector fitness) {
        this.fitness = fitness;
    }

    public String toString() {
        double[] fitnessValues;
        StringBuffer result = new StringBuffer("values=[");
        int i = 0;
        while (i < this.values.length) {
            if (i != 0) {
                result.append(",");
            }
            result.append(this.values[i]);
            ++i;
        }
        result.append(", fitness: [");
        double[] dArray = fitnessValues = this.getFitnessValues();
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            double d = dArray[n];
            result.append(d);
            ++n;
        }
        result.append("]");
        return result.toString();
    }
}

