/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math.optimization.ec.es;

import edu.udo.cs.yale.tools.math.optimization.ec.es.Individual;
import edu.udo.cs.yale.tools.math.optimization.ec.es.Population;
import edu.udo.cs.yale.tools.math.optimization.ec.es.PopulationOperator;
import java.util.LinkedList;
import java.util.Random;

public class GaussianMutation
implements PopulationOperator {
    private double[] sigma;
    private double[] min;
    private double[] max;
    private int[] valueTypes;
    private Random random;

    public GaussianMutation(double[] sigma, double[] min, double[] max, int[] valueTypes, Random random) {
        this.sigma = sigma;
        this.min = min;
        this.max = max;
        this.valueTypes = valueTypes;
        this.random = random;
    }

    public void setSigma(double[] sigma) {
        this.sigma = sigma;
    }

    public double[] getSigma() {
        return this.sigma;
    }

    public void operate(Population population) {
        LinkedList<Individual> newIndividuals = new LinkedList<Individual>();
        int i = 0;
        while (i < population.getNumberOfIndividuals()) {
            Individual clone = (Individual)population.get(i).clone();
            double[] values = clone.getValues();
            int j = 0;
            while (j < values.length) {
                int n = j;
                values[n] = values[n] + this.random.nextGaussian() * this.sigma[j];
                if (this.valueTypes[j] == 1) {
                    values[j] = (int)Math.round(values[j]);
                }
                if (values[j] < this.min[j]) {
                    values[j] = this.min[j];
                }
                if (values[j] > this.max[j]) {
                    values[j] = this.max[j];
                }
                ++j;
            }
            clone.setValues(values);
            newIndividuals.add(clone);
            ++i;
        }
        population.addAll(newIndividuals);
    }
}

