/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math.optimization.ec.es;

import edu.udo.cs.yale.datatable.SimpleDataTable;
import edu.udo.cs.yale.datatable.SimpleDataTableRow;
import edu.udo.cs.yale.gui.plotter.SimplePlotterDialog;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.RandomGenerator;
import edu.udo.cs.yale.tools.math.optimization.Optimization;
import edu.udo.cs.yale.tools.math.optimization.ec.es.BoltzmannSelection;
import edu.udo.cs.yale.tools.math.optimization.ec.es.Crossover;
import edu.udo.cs.yale.tools.math.optimization.ec.es.CutSelection;
import edu.udo.cs.yale.tools.math.optimization.ec.es.GaussianMutation;
import edu.udo.cs.yale.tools.math.optimization.ec.es.Individual;
import edu.udo.cs.yale.tools.math.optimization.ec.es.NonDominatedSortingSelection;
import edu.udo.cs.yale.tools.math.optimization.ec.es.Population;
import edu.udo.cs.yale.tools.math.optimization.ec.es.PopulationOperator;
import edu.udo.cs.yale.tools.math.optimization.ec.es.PopulationPlotter;
import edu.udo.cs.yale.tools.math.optimization.ec.es.RankSelection;
import edu.udo.cs.yale.tools.math.optimization.ec.es.RouletteWheel;
import edu.udo.cs.yale.tools.math.optimization.ec.es.SparsityMutation;
import edu.udo.cs.yale.tools.math.optimization.ec.es.StochasticUniversalSampling;
import edu.udo.cs.yale.tools.math.optimization.ec.es.SwitchingMutation;
import edu.udo.cs.yale.tools.math.optimization.ec.es.TournamentSelection;
import edu.udo.cs.yale.tools.math.optimization.ec.es.UniformSelection;
import edu.udo.cs.yale.tools.math.optimization.ec.es.VarianceAdaption;
import java.awt.Dialog;
import java.awt.Window;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class ESOptimization
implements Optimization {
    public static final int VALUE_TYPE_DOUBLE = 0;
    public static final int VALUE_TYPE_INT = 1;
    public static final String[] SELECTION_TYPES = new String[]{"uniform", "cut", "roulette wheel", "stochastic universal sampling", "Boltzmann", "rank", "tournament", "non dominated sorting"};
    public static final int UNIFORM_SELECTION = 0;
    public static final int CUT_SELECTION = 1;
    public static final int ROULETTE_WHEEL = 2;
    public static final int STOCHASTIC_UNIVERSAL = 3;
    public static final int BOLTZMANN_SELECTION = 4;
    public static final int RANK_SELECTION = 5;
    public static final int TOURNAMENT_SELECTION = 6;
    public static final int NON_DOMINATED_SORTING_SELECTION = 7;
    public static final String[] MUTATION_TYPES = new String[]{"none", "gaussian_mutation", "switching_mutation", "sparsity_mutation"};
    public static final int NO_MUTATION = 0;
    public static final int GAUSSIAN_MUTATION = 1;
    public static final int SWITCHING_MUTATION = 2;
    public static final int SPARSITY_MUTATION = 3;
    public static final String[] POPULATION_INIT_TYPES = new String[]{"random", "min", "max"};
    public static final int INIT_TYPE_RANDOM = 0;
    public static final int INIT_TYPE_MIN = 1;
    public static final int INIT_TYPE_MAX = 2;
    private double[] min;
    private double[] max;
    private int[] valueTypes;
    private int populationSize;
    private int individualSize;
    private int maxGenerations;
    private int generationsWithoutImprovement;
    private int initType = 0;
    private int mutationType = 1;
    private PopulationOperator mutation;
    private Population population;
    private Collection<PopulationOperator> popOps;
    private boolean showPlot = false;
    private int totalEvalCounter = 0;
    private int actualEvalCounter = 0;
    private RandomGenerator random;

    public ESOptimization(double minValue, double maxValue, int populationSize, int individualSize, int initType, int maxGenerations, int generationsWithoutImprovement, int selectionType, double tournamentFraction, boolean keepBest, int mutationType, double crossoverProb, boolean showPlot, RandomGenerator random) {
        this.random = random;
        this.showPlot = showPlot;
        this.populationSize = populationSize;
        this.individualSize = individualSize;
        this.min = new double[individualSize];
        this.max = new double[individualSize];
        int m = 0;
        while (m < this.min.length) {
            this.min[m] = minValue;
            this.max[m] = maxValue;
            ++m;
        }
        this.valueTypes = new int[individualSize];
        this.initType = initType;
        this.maxGenerations = maxGenerations;
        this.generationsWithoutImprovement = generationsWithoutImprovement < 1 ? this.maxGenerations : generationsWithoutImprovement;
        this.mutationType = mutationType;
        this.popOps = new LinkedList<PopulationOperator>();
        switch (selectionType) {
            case 0: {
                this.popOps.add(new UniformSelection(populationSize, keepBest, random));
                break;
            }
            case 1: {
                this.popOps.add(new CutSelection(populationSize));
                break;
            }
            case 2: {
                this.popOps.add(new RouletteWheel(populationSize, keepBest, random));
                break;
            }
            case 3: {
                this.popOps.add(new StochasticUniversalSampling(populationSize, keepBest, random));
                break;
            }
            case 4: {
                this.popOps.add(new BoltzmannSelection(populationSize, 1.0, this.maxGenerations, true, keepBest, random));
                break;
            }
            case 5: {
                this.popOps.add(new RankSelection(populationSize, keepBest, random));
                break;
            }
            case 6: {
                this.popOps.add(new TournamentSelection(populationSize, tournamentFraction, keepBest, random));
                break;
            }
            case 7: {
                this.popOps.add(new NonDominatedSortingSelection(populationSize));
                this.popOps.add(new PopulationPlotter());
            }
        }
        this.popOps.add(new Crossover(crossoverProb, random));
        switch (mutationType) {
            case 1: {
                GaussianMutation gm = new GaussianMutation(new double[0], this.min, this.max, this.valueTypes, random);
                this.popOps.add(gm);
                this.popOps.add(new VarianceAdaption(gm, individualSize));
                this.recalculateSigma(gm, this.individualSize);
                this.mutation = gm;
                break;
            }
            case 2: {
                this.mutation = new SwitchingMutation(1.0 / (double)individualSize, this.min, this.max, this.valueTypes, random);
                this.popOps.add(this.mutation);
                break;
            }
            case 3: {
                this.mutation = new SparsityMutation(1.0 / (double)individualSize, this.min, this.max, this.valueTypes, random);
                this.popOps.add(this.mutation);
                break;
            }
        }
    }

    public abstract PerformanceVector evaluateIndividual(Individual var1) throws OperatorException;

    public void nextIteration() throws OperatorException {
    }

    public double getMin(int index) {
        return this.min[index];
    }

    public double getMax(int index) {
        return this.max[index];
    }

    public void setMin(int index, double v) {
        this.min[index] = v;
        if (this.mutationType == 1) {
            this.recalculateSigma((GaussianMutation)this.mutation, this.individualSize);
        }
    }

    public void setMax(int index, double v) {
        this.max[index] = v;
        if (this.mutationType == 1) {
            this.recalculateSigma((GaussianMutation)this.mutation, this.individualSize);
        }
    }

    protected void recalculateSigma(GaussianMutation mutation, int individualSize) {
        double[] sigma = new double[individualSize];
        int s = 0;
        while (s < sigma.length) {
            sigma[s] = Math.abs(this.max[s] - this.min[s]) / 10.0;
            ++s;
        }
        mutation.setSigma(sigma);
    }

    public int getValueType(int index) {
        return this.valueTypes[index];
    }

    public void setValueType(int index, int type) {
        this.valueTypes[index] = type;
    }

    public void optimize() throws OperatorException {
        this.totalEvalCounter = 0;
        this.actualEvalCounter = 0;
        switch (this.initType) {
            case 0: {
                this.population = this.createRandomStartPopulation();
                break;
            }
            case 1: {
                this.population = this.createMinStartPopulation();
                break;
            }
            case 2: {
                this.population = this.createMaxStartPopulation();
                break;
            }
        }
        this.evaluate(this.population);
        SimpleDataTable dataTable = null;
        Window plotter = null;
        if (this.showPlot) {
            dataTable = new SimpleDataTable("Fitness vs. Generations", new String[]{"Generations", "Best Fitness", "Current Fitness"});
            plotter = new SimplePlotterDialog(dataTable, false);
            ((SimplePlotterDialog)plotter).setXAxis(0);
            ((SimplePlotterDialog)plotter).plotColumn(1, true);
            ((SimplePlotterDialog)plotter).plotColumn(2, true);
            ((Dialog)plotter).setVisible(true);
            dataTable.add(new SimpleDataTableRow(new double[]{0.0, this.population.getBestEver().getFitness().getMainCriterion().getFitness(), this.population.getCurrentBest().getFitness().getMainCriterion().getFitness()}));
        }
        while (true) {
            if (this.population.getGeneration() >= this.maxGenerations) {
                LogService.logMessage("ES finished: maximum number of iterations reached.", 2);
                break;
            }
            if (this.population.getGenerationsWithoutImprovement() > this.generationsWithoutImprovement) {
                LogService.logMessage("ES converged in generation " + this.population.getGeneration() + ": No improvement in last " + this.generationsWithoutImprovement + " generations.", 2);
                break;
            }
            Iterator<PopulationOperator> i = this.popOps.iterator();
            while (i.hasNext()) {
                i.next().operate(this.population);
            }
            this.evaluate(this.population);
            if (this.showPlot) {
                dataTable.add(new SimpleDataTableRow(new double[]{this.population.getGeneration(), this.population.getBestEver().getFitness().getMainCriterion().getFitness(), this.population.getCurrentBest().getFitness().getMainCriterion().getFitness()}));
            }
            this.population.nextGeneration();
            this.nextIteration();
        }
        if (this.showPlot) {
            plotter.dispose();
        }
        LogService.logMessage("ES Evaluations: " + this.actualEvalCounter + " / " + this.totalEvalCounter, 2);
    }

    private void evaluate(Population population) throws OperatorException {
        Individual currentBest = null;
        int i = 0;
        while (i < population.getNumberOfIndividuals()) {
            Individual current = population.get(i);
            if (current.getFitness() == null) {
                PerformanceVector fitness = this.evaluateIndividual(current);
                current.setFitness(fitness);
                if (currentBest == null || fitness.getMainCriterion().getFitness() > currentBest.getFitness().getMainCriterion().getFitness()) {
                    currentBest = (Individual)current.clone();
                    currentBest.setFitness(current.getFitness());
                }
                ++this.actualEvalCounter;
            }
            ++this.totalEvalCounter;
            ++i;
        }
        if (currentBest != null) {
            population.setCurrentBest(currentBest);
            Individual bestEver = population.getBestEver();
            if (bestEver == null || currentBest.getFitness().getMainCriterion().getFitness() > bestEver.getFitness().getMainCriterion().getFitness()) {
                Individual bestEverClone = (Individual)currentBest.clone();
                bestEverClone.setFitness(currentBest.getFitness());
                population.setBestEver(bestEverClone);
            }
        }
    }

    public int getGeneration() {
        return this.population.getGeneration();
    }

    public double getBestFitnessInGeneration() {
        return this.population.getCurrentBest().getFitnessValues()[0];
    }

    public double getBestFitnessEver() {
        return this.population.getBestEver().getFitnessValues()[0];
    }

    public PerformanceVector getBestPerformanceEver() {
        return this.population.getBestEver().getFitness();
    }

    public Population getPopulation() {
        return this.population;
    }

    public double[] getBestValuesEver() {
        return this.population.getBestEver().getValues();
    }

    private Population createRandomStartPopulation() {
        Population population = new Population();
        int p = 0;
        while (p < this.populationSize) {
            double[] alphas = new double[this.individualSize];
            int j = 0;
            while (j < alphas.length) {
                alphas[j] = this.random.nextDoubleInRange(this.min[j], this.max[j]);
                ++j;
            }
            population.add(new Individual(alphas));
            ++p;
        }
        return population;
    }

    private Population createMinStartPopulation() {
        Population population = new Population();
        int p = 0;
        while (p < this.populationSize) {
            double[] alphas = new double[this.individualSize];
            int j = 0;
            while (j < alphas.length) {
                alphas[j] = this.min[j];
                ++j;
            }
            population.add(new Individual(alphas));
            ++p;
        }
        return population;
    }

    private Population createMaxStartPopulation() {
        Population population = new Population();
        int p = 0;
        while (p < this.populationSize) {
            double[] alphas = new double[this.individualSize];
            int j = 0;
            while (j < alphas.length) {
                alphas[j] = this.max[j];
                ++j;
            }
            population.add(new Individual(alphas));
            ++p;
        }
        return population;
    }
}

