/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math;

import edu.udo.cs.yale.tools.math.Complex;
import edu.udo.cs.yale.tools.math.FastFourierTransform;
import edu.udo.cs.yale.tools.math.Peak;

public class SpectrumFilter {
    public static final int NONE = 0;
    public static final int ERB = 1;
    public static final int LOG = 2;
    public static final int LOG2 = 3;
    private int weightType;

    public SpectrumFilter(int weightType) {
        this.weightType = weightType;
    }

    public Peak[] filter(Complex[] spectrum, int totalSize) {
        Peak[] result = new Peak[spectrum.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new Peak(FastFourierTransform.convertFrequency(i, spectrum.length, totalSize), this.filterValue(spectrum[i].getMagnitude(spectrum.length * 2), i));
            ++i;
        }
        return result;
    }

    private double filterValue(double value, int index) {
        switch (this.weightType) {
            case 1: {
                return value * (21.4 * Math.log(0.00437 * (double)index + 1.0) / Math.log(10.0));
            }
            case 2: {
                return value * (10.0 * Math.log(index + 1) / Math.log(20.0));
            }
            case 3: {
                return value * (0.7 * Math.log(5 * index + 1));
            }
        }
        return value;
    }
}

