/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math;

import edu.udo.cs.yale.operator.ResultObjectAdapter;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.math.Averagable;
import edu.udo.cs.yale.tools.math.AverageVector;
import java.util.ArrayList;
import java.util.Iterator;

public class RunVector
extends ResultObjectAdapter {
    private ArrayList<AverageVector> vectorList = new ArrayList();

    public void addVector(AverageVector av) {
        this.vectorList.add(av);
    }

    public AverageVector getVector(int index) {
        return this.vectorList.get(index);
    }

    public ArrayList getVectorList() {
        return this.vectorList;
    }

    public int size() {
        return this.vectorList.size();
    }

    public AverageVector average() {
        try {
            AverageVector output = (AverageVector)this.getVector(0).clone();
            int i = 1;
            while (i < this.size()) {
                AverageVector av = this.getVector(i);
                int j = 0;
                while (j < av.size()) {
                    output.getAveragable(j).buildAverage(av.getAveragable(j));
                    ++j;
                }
                ++i;
            }
            return output;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone of average vector is not supported: " + e.getMessage());
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer("RunVector:" + Tools.getLineSeparator());
        Iterator<AverageVector> i = this.vectorList.iterator();
        while (i.hasNext()) {
            result.append(i.next() + Tools.getLineSeparator());
        }
        return result.toString();
    }

    public String toResultString() {
        String result = "";
        AverageVector averageVector = this.average();
        int averagableIndex = 0;
        while (averagableIndex < averageVector.size()) {
            result = String.valueOf(result) + "Time series of averagable '" + this.getVector(0).getAveragable(averagableIndex).getName() + "':";
            int timeIndex = 0;
            while (timeIndex < this.size()) {
                AverageVector currentAveragables = this.getVector(timeIndex);
                Averagable averagable = currentAveragables.getAveragable(averagableIndex);
                result = String.valueOf(result) + "  " + averagable.getAverage();
                ++timeIndex;
            }
            result = String.valueOf(result) + Tools.getLineSeparator();
            ++averagableIndex;
        }
        int i = 0;
        while (i < averageVector.size()) {
            Averagable averagable = averageVector.getAveragable(i);
            result = String.valueOf(result) + "  Average of averagable '" + averagable.getName() + "':  " + averagable.getAverage();
            if (averagable.getVariance() >= 0.0) {
                result = String.valueOf(result) + "  (" + averagable.getVariance() + ")";
            }
            result = String.valueOf(result) + Tools.getLineSeparator();
            ++i;
        }
        result = String.valueOf(result) + Tools.getLineSeparator();
        return result;
    }

    public String getExtension() {
        return "rvc";
    }

    public String getFileDescription() {
        return "run vector";
    }
}

