/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math;

public class MathFunctions {
    protected static final double[] DIVISOR_COEFFICIENTS_0 = new double[]{-59.96335010141079, 98.00107541859997, -56.67628574690703, 13.931260938727968, -1.2391658386738125};
    protected static final double[] DIVIDER_COEFFICIENTS_0 = new double[]{1.0, 1.9544885833814176, 4.676279128988815, 86.36024213908905, -225.46268785411937, 200.26021238006066, -82.03722561683334, 15.90562251262117, -1.1833162112133};
    protected static final double[] DIVISOR_COEFFICIENTS_1 = new double[]{4.0554489230596245, 31.525109459989388, 57.16281922464213, 44.08050738932008, 14.684956192885803, 2.1866330685079025, -0.1402560791713545, -0.03504246268278482, -8.574567851546854E-4};
    protected static final double[] DIVIDER_COEFFICIENTS_1 = new double[]{1.0, 15.779988325646675, 45.39076351288792, 41.3172038254672, 15.04253856929075, 2.504649462083094, -0.14218292285478779, -0.03808064076915783, -9.332594808954574E-4};
    protected static final double[] DIVISOR_COEFFICIENTS_3 = new double[]{3.2377489177694603, 6.915228890689842, 3.9388102529247444, 1.3330346081580755, 0.20148538954917908, 0.012371663481782003, 3.0158155350823543E-4, 2.6580697468673755E-6, 6.239745391849833E-9};
    protected static final double[] DIVIDER_COEFFICIENTS_3 = new double[]{1.0, 6.02427039364742, 3.6798356385616087, 1.3770209948908132, 0.21623699359449663, 0.013420400608854318, 3.2801446468212774E-4, 2.8924786474538068E-6, 6.790194080099813E-9};

    public static double tanh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / (Math.exp(x) + Math.exp(-x));
    }

    public static double normalInverse(double probability) {
        double smallArgumentEnd = Math.exp(-2.0);
        double rootedPi = Math.sqrt(Math.PI * 2);
        if (probability <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (probability >= 1.0) {
            throw new IllegalArgumentException();
        }
        boolean wrappedArround = false;
        if (probability > 1.0 - smallArgumentEnd) {
            probability = 1.0 - probability;
            wrappedArround = true;
        }
        if (probability > smallArgumentEnd) {
            double squaredProbability = (probability -= 0.5) * probability;
            double x = probability;
            x += probability * (squaredProbability * MathFunctions.solvePolynomial(squaredProbability, DIVISOR_COEFFICIENTS_0) / MathFunctions.solvePolynomial(squaredProbability, DIVIDER_COEFFICIENTS_0));
            return x *= rootedPi;
        }
        double x = Math.sqrt(-2.0 * Math.log(probability));
        double inversedX = 1.0 / x;
        x = x < 8.0 ? x - Math.log(x) / x - inversedX * MathFunctions.solvePolynomial(inversedX, DIVISOR_COEFFICIENTS_1) / MathFunctions.solvePolynomial(inversedX, DIVIDER_COEFFICIENTS_1) : x - Math.log(x) / x - inversedX * MathFunctions.solvePolynomial(inversedX, DIVISOR_COEFFICIENTS_3) / MathFunctions.solvePolynomial(inversedX, DIVIDER_COEFFICIENTS_3);
        if (!wrappedArround) {
            x = -x;
        }
        return x;
    }

    public static double solvePolynomial(double x, double[] coefficients) {
        double value = coefficients[0];
        int i = 1;
        while (i < coefficients.length) {
            value += coefficients[i] * Math.pow(x, i);
            ++i;
        }
        return value;
    }
}

