/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math;

import Jama.Matrix;

public class LinearRegression {
    private double[] coefficients = null;

    public LinearRegression(Matrix x, Matrix y, double ridge) {
        this.calculate(x, y, ridge);
    }

    public LinearRegression(Matrix x, Matrix y, double[] w, double ridge) {
        Matrix weightedIndependent = new Matrix(x.getRowDimension(), x.getColumnDimension());
        Matrix weightedDependent = new Matrix(x.getRowDimension(), 1);
        int i = 0;
        while (i < w.length) {
            double sqrtWeight = Math.sqrt(w[i]);
            int j = 0;
            while (j < x.getColumnDimension()) {
                weightedIndependent.set(i, j, x.get(i, j) * sqrtWeight);
                ++j;
            }
            weightedDependent.set(i, 0, y.get(i, 0) * sqrtWeight);
            ++i;
        }
        this.calculate(weightedIndependent, weightedDependent, ridge);
    }

    private void calculate(Matrix x, Matrix y, double ridge) {
        int numberOfColumns = x.getColumnDimension();
        this.coefficients = new double[numberOfColumns];
        Matrix xt = x.transpose();
        boolean success = true;
        do {
            Matrix ss = xt.times(x);
            int i = 0;
            while (i < numberOfColumns) {
                ss.set(i, i, ss.get(i, i) + ridge);
                ++i;
            }
            Matrix bb = xt.times(y);
            int i2 = 0;
            while (i2 < numberOfColumns) {
                this.coefficients[i2] = bb.get(i2, 0);
                ++i2;
            }
            try {
                Matrix solution = ss.solve(new Matrix(this.coefficients, this.coefficients.length));
                i2 = 0;
                while (i2 < numberOfColumns) {
                    this.coefficients[i2] = solution.get(i2, 0);
                    ++i2;
                }
                success = true;
            }
            catch (Exception ex) {
                ridge *= 10.0;
                success = false;
            }
        } while (!success);
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }
}

