/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math;

import edu.udo.cs.yale.tools.math.Peak;
import edu.udo.cs.yale.tools.math.PeakFinder;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryPeakFinder
implements PeakFinder {
    private double average;

    @Override
    public List<Peak> getPeaks(Peak[] series) {
        this.average = 0.0;
        int i = 0;
        while (i < series.length) {
            this.average += series[i].getMagnitude();
            ++i;
        }
        this.average /= (double)series.length;
        LinkedList<Area> areaStack = new LinkedList<Area>();
        Area startArea = new Area(0, series.length);
        areaStack.add(startArea);
        LinkedList<Peak> result = new LinkedList<Peak>();
        while (areaStack.size() != 0) {
            int newLeftEnd;
            Area current = (Area)areaStack.removeLast();
            int maxIndex = this.findMaximum(series, current.start, current.end);
            int newRightEnd = this.getLeftEndOfPeak(series, maxIndex, current.start);
            if (newRightEnd > current.start) {
                areaStack.add(new Area(current.start, newRightEnd));
            }
            if ((newLeftEnd = this.getRightEndOfPeak(series, maxIndex, current.end)) < current.end) {
                areaStack.add(new Area(newLeftEnd, current.end));
            }
            result.add(series[maxIndex]);
        }
        return result;
    }

    private int getLeftEndOfPeak(Peak[] series, int max, int startIndex) {
        int left = max;
        long sloppyCount = 2L + Math.round(Math.sqrt((double)max / (double)series.length) * 5.0);
        boolean ok = false;
        block0: do {
            ok = false;
            double lastValue = series[left].getMagnitude();
            int i = 0;
            while ((long)i < sloppyCount + 1L) {
                if (--left <= startIndex) continue block0;
                double tolerance = Math.sqrt((double)left / (double)series.length) + 1.2;
                if (series[left].getMagnitude() < 2.0 * this.average || series[left].getMagnitude() < tolerance * lastValue) {
                    ok = true;
                    continue block0;
                }
                ++i;
            }
        } while (ok);
        if (left <= startIndex) {
            return startIndex;
        }
        return left;
    }

    private int getRightEndOfPeak(Peak[] series, int max, int endIndex) {
        int right = max;
        long sloppyCount = 2L + Math.round(Math.sqrt((double)max / (double)series.length) * 5.0);
        boolean ok = false;
        block0: do {
            ok = false;
            double lastValue = series[right].getMagnitude();
            int i = 0;
            while ((long)i < sloppyCount + 1L) {
                if (++right >= endIndex) continue block0;
                double tolerance = Math.sqrt((double)right / (double)series.length) + 1.2;
                if (series[right].getMagnitude() < 2.0 * this.average || series[right].getMagnitude() < tolerance * lastValue) {
                    ok = true;
                    continue block0;
                }
                ++i;
            }
        } while (ok);
        if (right >= endIndex) {
            return endIndex;
        }
        return right;
    }

    private int findMaximum(Peak[] series, int startIndex, int endIndex) {
        int maxIndex = startIndex;
        double maxValue = Double.NEGATIVE_INFINITY;
        int i = startIndex;
        while (i < endIndex) {
            if (series[i].getMagnitude() > maxValue) {
                maxValue = series[i].getMagnitude();
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    private static class Area {
        private int start;
        private int end;

        private Area(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "start: " + this.start + ", end: " + this.end;
        }
    }
}

