/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math;

import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.ResultObjectAdapter;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.math.Averagable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class AverageVector
extends ResultObjectAdapter
implements Comparable,
Cloneable {
    private List<Averagable> averagesList = new ArrayList<Averagable>();

    public abstract Object clone() throws CloneNotSupportedException;

    public boolean equals(Object o) {
        if (!(o instanceof AverageVector)) {
            return false;
        }
        AverageVector v = (AverageVector)o;
        return this.averagesList.equals(v.averagesList);
    }

    public int hashCode() {
        return this.averagesList.hashCode();
    }

    public int size() {
        return this.averagesList.size();
    }

    public void addAveragable(Averagable avg) {
        this.averagesList.add(avg);
    }

    public void removeAveragable(Averagable avg) {
        this.averagesList.remove(avg);
    }

    public Averagable getAveragable(int index) {
        return this.averagesList.get(index);
    }

    public Averagable getAveragable(String name) {
        for (Averagable a : this.averagesList) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public int getSize() {
        return this.averagesList.size();
    }

    public String toResultString() {
        String result = String.valueOf(this.getName()) + ":" + Tools.getLineSeparator();
        Iterator<Averagable> i = this.averagesList.iterator();
        while (i.hasNext()) {
            result = String.valueOf(result) + i.next().toResultString() + Tools.getLineSeparator();
        }
        return result;
    }

    public String toString() {
        String result = "AverageVector [";
        int i = 0;
        while (i < this.size()) {
            Averagable avg = this.getAveragable(i);
            if (i > 0) {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + avg;
            ++i;
        }
        return String.valueOf(result) + "]";
    }

    public Component getVisualizationComponent(IOContainer container) {
        JPanel mainPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        mainPanel.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(11, 11, 11, 11);
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JLabel mainLabel = new JLabel("<html><h2>" + this.getName() + " (" + this.size() + ")</h2></html>");
        layout.setConstraints(mainLabel, c);
        mainPanel.add(mainLabel);
        int i = 0;
        while (i < this.size()) {
            Averagable avg = this.getAveragable(i);
            Component visualizationComponent = avg.getVisualizationComponent(container);
            layout.setConstraints(visualizationComponent, c);
            mainPanel.add(visualizationComponent);
            ++i;
        }
        return new JScrollPane(mainPanel);
    }

    public void buildAverages(AverageVector av) {
        if (this.size() != av.size()) {
            throw new IllegalArgumentException("Performance vectors have different size!");
        }
        int i = 0;
        while (i < this.size()) {
            this.getAveragable(i).buildAverage(av.getAveragable(i));
            ++i;
        }
    }
}

