/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.jdbc;

import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.ParameterService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.jdbc.DriverAdapter;
import edu.udo.cs.yale.tools.jdbc.JDBCProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseService {
    private static List<JDBCProperties> jdbcProperties = new ArrayList<JDBCProperties>();

    public static void init(boolean searchForJDBDriversInLibDirectory, boolean searchForJDBCDriversInClasspath) throws IOException {
        DatabaseService.registerAllJDBCDrivers(searchForJDBDriversInLibDirectory, searchForJDBCDriversInClasspath);
        URL propertyURL = Tools.getResource("jdbc_properties.xml");
        if (propertyURL != null) {
            DatabaseService.loadJDBCProperties(propertyURL.openStream(), "jdbc_properties.xml");
        }
    }

    private static void registerAllJDBCDrivers(boolean searchForJDBDriversInLibDirectory, boolean searchForJDBCDriversInClasspath) {
        File[] allFiles;
        File jdbcDirectory;
        if (searchForJDBDriversInLibDirectory && (jdbcDirectory = ParameterService.getLibraryFile("jdbc")) != null && jdbcDirectory.exists() && (allFiles = jdbcDirectory.listFiles()) != null) {
            File[] fileArray = allFiles;
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                File f = fileArray[n];
                if (f.getName().endsWith(".jar") || f.getName().endsWith(".zip")) {
                    DatabaseService.registerDynamicJDBCDrivers(f);
                }
                ++n;
            }
        }
        if (searchForJDBCDriversInClasspath) {
            String classpath = System.getProperty("java.class.path");
            String[] pathComponents = classpath.split(File.pathSeparator);
            int i = 0;
            while (i < pathComponents.length) {
                String path = pathComponents[i].trim();
                if (path.endsWith(".jar") || path.endsWith(".zip")) {
                    DatabaseService.registerClasspathJDBCDrivers(new File(path).getAbsoluteFile());
                }
                ++i;
            }
        }
    }

    private static void registerDynamicJDBCDrivers(File file) {
        URLClassLoader ucl = null;
        try {
            URL u = new URL("jar:file:" + file.getAbsolutePath() + "!/");
            ucl = new URLClassLoader(new URL[]{u});
        }
        catch (MalformedURLException e) {
            LogService.logMessage("DatabaseService: cannot create class loader for file '" + file + "': " + e.getMessage(), 6);
        }
        if (ucl != null) {
            try {
                JarFile jarFile = new JarFile(file);
                LinkedList<String> driverNames = new LinkedList<String>();
                Tools.findImplementationsInJar(ucl, jarFile, Driver.class, driverNames);
                Iterator i = driverNames.iterator();
                while (i.hasNext()) {
                    DatabaseService.registerDynamicJDBCDriver(ucl, (String)i.next());
                }
            }
            catch (Exception e) {
                LogService.logMessage("DatabaseService: cannot register drivers for file '" + file + "': " + e.getMessage(), 6);
            }
        }
    }

    private static void registerDynamicJDBCDriver(URLClassLoader ucl, String driverName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        if (!driverName.equals(DriverAdapter.class.getName())) {
            Driver d = (Driver)Class.forName(driverName, true, ucl).newInstance();
            DriverManager.registerDriver(new DriverAdapter(d));
        }
    }

    private static void registerClasspathJDBCDrivers(File file) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException e) {
            LogService.logMessage("DatabaseService: cannot register drivers from file '" + file + "': " + e.getMessage(), 6);
            return;
        }
        LinkedList<String> driverNames = new LinkedList<String>();
        Tools.findImplementationsInJar(jarFile, Driver.class, driverNames);
        for (String driverName : driverNames) {
            try {
                Class.forName(driverName);
            }
            catch (Exception e) {
                LogService.logMessage("DatabaseService: cannot register driver '" + driverName + "' from file '" + file + "': " + e.getMessage(), 6);
            }
        }
    }

    private static void loadJDBCProperties(InputStream in, String name) {
        jdbcProperties.clear();
        LogService.logMessage("Loading JDBC driver information from '" + name + "'.", 3);
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        catch (Exception e) {
            LogService.logException("Cannot read JDBC driver description file '" + name + "': no valid XML!", null, e);
        }
        if (document != null) {
            if (!document.getDocumentElement().getTagName().toLowerCase().equals("drivers")) {
                LogService.logMessage("JDBC driver description file '" + name + "': outermost tag must be <drivers>!", 6);
                return;
            }
            NodeList driverTags = document.getDocumentElement().getElementsByTagName("driver");
            int i = 0;
            while (i < driverTags.getLength()) {
                Element currentElement = (Element)driverTags.item(i);
                try {
                    DatabaseService.addDriverInformation(currentElement);
                }
                catch (Exception e) {
                    Attr currentNameAttr = currentElement.getAttributeNode("name");
                    if (currentNameAttr != null) {
                        LogService.logMessage("JDBC driver description: cannot register '" + currentNameAttr.getValue() + "': " + e, 6);
                    }
                    LogService.logMessage("JDBC driver registration: cannot register '" + currentElement + "': " + e, 6);
                }
                ++i;
            }
        }
    }

    private static void addDriverInformation(Element driverElement) throws Exception {
        Attr nameAttr = driverElement.getAttributeNode("name");
        Attr portAttr = driverElement.getAttributeNode("defaultport");
        Attr urlAttr = driverElement.getAttributeNode("urlprefix");
        Attr dbNameAttr = driverElement.getAttributeNode("dbnameseperator");
        if (nameAttr == null) {
            throw new Exception("Missing name for <driver> tag");
        }
        if (portAttr == null) {
            throw new Exception("Missing defaultport for <driver> tag");
        }
        if (urlAttr == null) {
            throw new Exception("Missing urlprefix for <driver> tag");
        }
        if (dbNameAttr == null) {
            throw new Exception("Missing dbnameseperator for <driver> tag");
        }
        JDBCProperties properties = new JDBCProperties(nameAttr.getValue(), portAttr.getValue(), urlAttr.getValue(), dbNameAttr.getValue());
        jdbcProperties.add(properties);
    }

    public static Enumeration<Driver> getAllDrivers() {
        return DriverManager.getDrivers();
    }

    public static String[] getAllDriverNames() {
        Enumeration<Driver> drivers = DatabaseService.getAllDrivers();
        LinkedList<String> driverNameList = new LinkedList<String>();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (driver instanceof DriverAdapter) {
                driverNameList.add(driver.toString());
                continue;
            }
            driverNameList.add(driver.getClass().getName());
        }
        Collections.sort(driverNameList);
        String[] driverArray = new String[driverNameList.size()];
        driverNameList.toArray(driverArray);
        return driverArray;
    }

    public static List<JDBCProperties> getJDBCProperties() {
        return jdbcProperties;
    }

    public static String[] getDBSystemNames() {
        String[] names = new String[jdbcProperties.size()];
        int counter = 0;
        Iterator<JDBCProperties> i = jdbcProperties.iterator();
        while (i.hasNext()) {
            names[counter++] = i.next().getName();
        }
        return names;
    }
}

