/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.jdbc;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.tools.LogService;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseHandler {
    private String databaseURL;
    private Connection myCon;

    public DatabaseHandler(String databaseURL) {
        this.databaseURL = databaseURL;
        this.myCon = null;
    }

    public void connect(String username, String passwd, boolean autoCommit) throws SQLException {
        if (this.myCon != null) {
            throw new SQLException("connect: Connection to database '" + this.databaseURL + "' already exists!");
        }
        this.myCon = username == null ? DriverManager.getConnection(this.databaseURL) : DriverManager.getConnection(this.databaseURL, username, passwd);
        this.myCon.setAutoCommit(autoCommit);
    }

    public void disconnect() throws SQLException {
        if (this.myCon == null) {
            throw new SQLException("Disconnect: was not connected.");
        }
        this.myCon.close();
        this.myCon = null;
    }

    public ResultSet query(String sqlQuery) throws SQLException {
        if (this.myCon == null) {
            throw new SQLException("Could not query database '" + this.databaseURL + "': not connected.");
        }
        if (!sqlQuery.toLowerCase().startsWith("select")) {
            throw new SQLException("Query: Only SQL-Statements starting with SELECT are allowed: " + sqlQuery);
        }
        Statement st = this.myCon.createStatement(1004, 1008);
        ResultSet rs = st.executeQuery(sqlQuery);
        return rs;
    }

    public void addColumn(Attribute attribute, String tableName) throws SQLException {
        Statement st = this.myCon.createStatement(1003, 1008);
        String query = "ALTER TABLE " + tableName + " ADD COLUMN " + DatabaseHandler.getDatabaseName(attribute) + " " + (attribute.isNominal() ? "VARCHAR(256)" : "REAL");
        st.execute(query);
        st.close();
    }

    public void removeColumn(Attribute attribute, String tableName) throws SQLException {
        Statement st = this.myCon.createStatement(1003, 1008);
        String query = "ALTER TABLE " + tableName + " DROP COLUMN " + DatabaseHandler.getDatabaseName(attribute);
        st.execute(query);
        st.close();
    }

    public int countRecords(ResultSet rs) throws SQLException {
        int numberOfRows = 0;
        LogService.logMessage("Counting records...", 0);
        rs.beforeFirst();
        while (rs.next()) {
            ++numberOfRows;
        }
        rs.beforeFirst();
        LogService.logMessage("...counted " + numberOfRows + " records.", 0);
        return numberOfRows;
    }

    public void commit() throws SQLException {
        if (this.myCon == null || this.myCon.isClosed()) {
            throw new SQLException("Could not commit: no open connection to database '" + this.databaseURL + "' !");
        }
        this.myCon.commit();
    }

    public static int getYaleTypeIndex(int sqlType) {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return 3;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2000: 
            case 2002: 
            case 2004: 
            case 2005: {
                return 1;
            }
            case 91: 
            case 92: 
            case 93: {
                return 6;
            }
        }
        return 1;
    }

    public static List<Attribute> createAttributes(ResultSet rs) throws SQLException {
        ResultSetMetaData metadata;
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        if (rs == null) {
            throw new IllegalArgumentException("Cannot create attributes: ResultSet must not be null!");
        }
        try {
            metadata = rs.getMetaData();
        }
        catch (NullPointerException npe) {
            throw new RuntimeException("Could not create attribute list: ResultSet object seems closed.");
        }
        int numberOfColumns = metadata.getColumnCount();
        int column = 1;
        while (column <= numberOfColumns) {
            String name = metadata.getColumnName(column);
            Attribute attribute = AttributeFactory.createAttribute(name, DatabaseHandler.getYaleTypeIndex(metadata.getColumnType(column)));
            attributes.add(attribute);
            ++column;
        }
        return attributes;
    }

    public static String getDatabaseName(Attribute attribute) {
        String name = attribute.getName();
        name = name.toUpperCase();
        name = name.replace('(', '_');
        name = name.replace(')', '_');
        return name;
    }

    public Map<String, List<String>> getAllTableMetaData() throws SQLException {
        if (this.myCon == null || this.myCon.isClosed()) {
            throw new SQLException("Could not retrieve all table names: no open connection to database '" + this.databaseURL + "' !");
        }
        DatabaseMetaData metaData = this.myCon.getMetaData();
        String[] types = new String[]{"TABLE"};
        ResultSet tableNames = metaData.getTables(null, null, "%", types);
        LinkedList<String> tableNameList = new LinkedList<String>();
        while (tableNames.next()) {
            String tableName = tableNames.getString(3);
            tableNameList.add(tableName);
        }
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        for (String tableName : tableNameList) {
            try {
                List<String> columnNames = this.getAllColumnNames(tableName);
                result.put(tableName, columnNames);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return result;
    }

    private List<String> getAllColumnNames(String tableName) throws SQLException {
        ResultSetMetaData metadata;
        if (tableName == null) {
            throw new SQLException("Cannot read column names: table name must not be null!");
        }
        ResultSet rs = this.query("SELECT * FROM " + tableName);
        LinkedList<String> result = new LinkedList<String>();
        try {
            metadata = rs.getMetaData();
        }
        catch (NullPointerException npe) {
            throw new SQLException("Could not create column name list: ResultSet object seems closed.");
        }
        int numberOfColumns = metadata.getColumnCount();
        int column = 1;
        while (column <= numberOfColumns) {
            String name = metadata.getColumnName(column);
            result.add(String.valueOf(tableName) + "." + name);
            ++column;
        }
        rs.close();
        return result;
    }
}

