/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.att;

import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.YaleLineReader;
import edu.udo.cs.yale.tools.att.AttributeDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeDataSourceCreator {
    private ArrayList<AttributeDataSource> sources = new ArrayList();

    public List<AttributeDataSource> getAttributeDataSources() {
        return this.sources;
    }

    public void loadData(File file, char[] commentChars, String columnSeparators, boolean useQuotes, boolean firstLineAsNames, int maxCounter) throws IOException {
        String defaultName;
        int i;
        this.sources.clear();
        String[] columnNames = null;
        int maxColumns = -1;
        int[] valueTypes = null;
        YaleLineReader lineReader = new YaleLineReader(columnSeparators, commentChars, useQuotes);
        BufferedReader in = new BufferedReader(new FileReader(file));
        int counter = 0;
        boolean first = true;
        while (maxCounter < 0 || counter <= maxCounter) {
            String[] columns = lineReader.readLine(in, -1);
            if (columns == null) break;
            if (maxColumns != -1 && maxColumns != columns.length) {
                throw new IOException("Number of columns in line " + counter + " was unexpected, was: " + columns.length + ", expected: " + maxColumns);
            }
            if (first) {
                maxColumns = columns.length;
                valueTypes = new int[maxColumns];
                i = 0;
                while (i < valueTypes.length) {
                    valueTypes[i] = 3;
                    ++i;
                }
                if (firstLineAsNames) {
                    columnNames = columns;
                } else {
                    AttributeDataSourceCreator.guessValueTypes(columns, valueTypes);
                }
                first = false;
            } else {
                AttributeDataSourceCreator.guessValueTypes(columns, valueTypes);
            }
            ++counter;
        }
        in.close();
        if (columnNames == null) {
            defaultName = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(File.separator) + 1);
            columnNames = new String[maxColumns];
            i = 0;
            while (i < columnNames.length) {
                columnNames[i] = String.valueOf(defaultName) + " (" + (i + 1) + ")";
                ++i;
            }
        } else if (columnNames.length < maxColumns) {
            defaultName = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(File.separator) + 1);
            String[] newColumnNames = new String[maxColumns];
            System.arraycopy(columnNames, 0, newColumnNames, 0, columnNames.length);
            int i2 = columnNames.length;
            while (i2 < newColumnNames.length) {
                newColumnNames[i2] = String.valueOf(defaultName) + " (" + (i2 + 1) + ")";
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < maxColumns) {
            this.sources.add(new AttributeDataSource(AttributeFactory.createAttribute(columnNames[i3], valueTypes[i3]), file, i3, "attribute"));
            ++i3;
        }
    }

    public static void guessValueTypes(String[] data, int[] valueTypes) {
        int c = 0;
        while (c < valueTypes.length) {
            String value = data[c];
            if (value != null && !value.equals("?")) {
                try {
                    double d = Double.parseDouble(value);
                    if (valueTypes[c] == 3 && (double)((int)d) != d) {
                        valueTypes[c] = 4;
                    }
                }
                catch (NumberFormatException e) {
                    valueTypes[c] = 1;
                }
            }
            ++c;
        }
    }
}

