/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import edu.udo.cs.yale.example.BinominalAttribute;
import edu.udo.cs.yale.example.NumericalAttribute;
import edu.udo.cs.yale.example.PolynominalAttribute;
import edu.udo.cs.yale.operator.IOContainer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class XMLSerialization {
    private static XMLSerialization singleton = new XMLSerialization();
    private XStream xStream = new XStream((HierarchicalStreamDriver)new XppDriver());

    public XMLSerialization() {
        this.xStream.setMode(1002);
        this.addAlias("IOContainer", IOContainer.class);
        this.addAlias("PolynominalAttribute", PolynominalAttribute.class);
        this.addAlias("BinominalAttribute", BinominalAttribute.class);
        this.addAlias("NumericalAttribute", NumericalAttribute.class);
    }

    public void addAlias(String name, Class clazz) {
        this.xStream.alias(name, clazz);
    }

    public void writeXML(Object object, OutputStream out) throws IOException {
        ObjectOutputStream xOut = this.xStream.createObjectOutputStream((Writer)new OutputStreamWriter(out));
        xOut.writeObject(object);
        xOut.close();
    }

    public Object fromXML(InputStream in) throws IOException {
        ObjectInputStream xIn = this.xStream.createObjectInputStream((Reader)new InputStreamReader(in));
        Object result = null;
        try {
            result = xIn.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Class not found: " + e.getMessage());
        }
        xIn.close();
        return result;
    }

    public static XMLSerialization getXMLSerialization() {
        return singleton;
    }
}

