/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorCreationException;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.OperatorService;
import edu.udo.cs.yale.tools.ParameterService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.WekaInstancesAdaptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WekaTools {
    public static ExampleSet toYaleExampleSet(Instances instances) {
        return WekaTools.toYaleExampleSet(instances, null, 0);
    }

    public static ExampleSet toYaleExampleSet(Instances instances, String attributeNamePrefix) {
        return WekaTools.toYaleExampleSet(instances, attributeNamePrefix, 0);
    }

    public static ExampleSet toYaleExampleSet(Instances instances, String attributeNamePrefix, int datamanagement) {
        int classIndex = instances.classIndex();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int number = 1;
        int i = 0;
        while (i < instances.numAttributes()) {
            weka.core.Attribute wekaAttribute = instances.attribute(i);
            int yaleAttributeValueType = 4;
            if (wekaAttribute.isNominal()) {
                yaleAttributeValueType = 1;
            } else if (wekaAttribute.isString()) {
                yaleAttributeValueType = 5;
            }
            Attribute attribute = AttributeFactory.createAttribute(wekaAttribute.name(), yaleAttributeValueType);
            if (i != classIndex && attributeNamePrefix != null && attributeNamePrefix.length() > 0) {
                attribute.setName(String.valueOf(attributeNamePrefix) + "_" + number++);
            }
            if (wekaAttribute.isNominal()) {
                int a = 0;
                while (a < wekaAttribute.numValues()) {
                    String nominalValue = wekaAttribute.value(a);
                    attribute.getMapping().mapString(nominalValue);
                    ++a;
                }
            }
            attributes.add(attribute);
            ++i;
        }
        Attribute label = null;
        if (classIndex >= 0) {
            label = (Attribute)attributes.get(classIndex);
            label.setName("label");
        }
        int j = 0;
        while (j < attributes.size()) {
            Attribute attribute = (Attribute)attributes.get(j);
            if (attribute.isNominal()) {
                attribute.getMapping().sortMappings();
            }
            ++j;
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        DataRowFactory factory = new DataRowFactory(datamanagement);
        LinkedList<DataRow> dataList = new LinkedList<DataRow>();
        int numberOfYaleAttributes = instances.numAttributes();
        int i2 = 0;
        while (i2 < instances.numInstances()) {
            Instance instance = instances.instance(i2);
            DataRow dataRow = factory.create(numberOfYaleAttributes);
            int a = 0;
            while (a < instances.numAttributes()) {
                Attribute attribute = table.getAttribute(a);
                double wekaValue = instance.value(a);
                if (attribute.isNominal()) {
                    String nominalValue = instances.attribute(a).value((int)wekaValue);
                    dataRow.set(attribute, attribute.getMapping().mapString(nominalValue));
                } else {
                    dataRow.set(attribute, wekaValue);
                }
                ++a;
            }
            dataList.add(dataRow);
            ++i2;
        }
        table.readExamples(new ListDataRowReader(dataList.iterator()));
        return table.createExampleSet(label);
    }

    public static Instances toWekaInstances(ExampleSet exampleSet, String name, int taskType) {
        return new WekaInstancesAdaptor(name, exampleSet, taskType);
    }

    public static String[] getWekaParametersFromList(List yaleParameters) {
        String[] parameters = new String[yaleParameters.size() * 2];
        Iterator i = yaleParameters.iterator();
        int j = 0;
        while (i.hasNext()) {
            Object[] parameter = (Object[])i.next();
            parameters[j++] = "-" + (String)parameter[0];
            parameters[j++] = (String)parameter[1];
        }
        return parameters;
    }

    public static String[] getWekaParametersFromTypes(Operator operator, List parameterTypes) {
        LinkedList<String> parameterStrings = new LinkedList<String>();
        for (ParameterType type : parameterTypes) {
            try {
                String defaultValue;
                if (type instanceof ParameterTypeBoolean) {
                    if (Boolean.valueOf(operator.getParameterAsBoolean(type.getKey())).equals(type.getDefaultValue())) continue;
                    parameterStrings.add("-" + type.getKey());
                    continue;
                }
                if (type instanceof ParameterTypeDouble) {
                    double defaultValue2;
                    double value = operator.getParameterAsDouble(type.getKey());
                    if (Double.isNaN(value) || !Double.isNaN(defaultValue2 = ((Double)type.getDefaultValue()).doubleValue()) && defaultValue2 == value) continue;
                    parameterStrings.add("-" + type.getKey());
                    String valueString = Tools.formatIntegerIfPossible(value);
                    parameterStrings.add(valueString);
                    continue;
                }
                String value = operator.getParameterAsString(type.getKey());
                if (value == null || (defaultValue = (String)type.getDefaultValue()) != null && defaultValue.equals(value)) continue;
                parameterStrings.add("-" + type.getKey());
                parameterStrings.add(value);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot use parameter " + type.getKey() + ": " + e.getMessage());
            }
        }
        String[] result = new String[parameterStrings.size()];
        parameterStrings.toArray(result);
        return result;
    }

    public static ParameterType guessParameterType(Option option, String[] options) {
        if (option.numArguments() == 0) {
            String defaultString = WekaTools.getStringDefault(option.name(), options);
            if (defaultString == null) {
                return new ParameterTypeBoolean(option.name(), option.description(), WekaTools.getBooleanDefault(option.name(), options));
            }
            return new ParameterTypeString(option.name(), option.description(), defaultString);
        }
        String defaultString = WekaTools.getStringDefault(option.name(), options);
        if (defaultString == null) {
            return new ParameterTypeString(option.name(), option.description());
        }
        try {
            double defaultValue = Double.parseDouble(defaultString);
            return new ParameterTypeDouble(option.name(), option.description(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, defaultValue);
        }
        catch (NumberFormatException e) {
            return new ParameterTypeString(option.name(), option.description(), defaultString);
        }
    }

    private static boolean getBooleanDefault(String key, String[] options) {
        int i = 0;
        while (i < options.length) {
            if (options[i].equals("-" + key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String getStringDefault(String key, String[] options) {
        int i = 0;
        while (i < options.length) {
            if (options[i].equals("-" + key) && i + 1 < options.length) {
                return options[i + 1];
            }
            ++i;
        }
        return null;
    }

    private static String[] removeMetaOptions(String[] options) {
        int index = -1;
        int i = 0;
        while (i < options.length) {
            if (options[i].trim().equals("--")) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return options;
        }
        String[] result = new String[index];
        System.arraycopy(options, 0, result, 0, index);
        return result;
    }

    public static void addParameterTypes(OptionHandler handler, List<ParameterType> types, List<ParameterType> wekaParameters, boolean meta, String metaParameter) {
        String[] defaultOptions = WekaTools.removeMetaOptions(handler.getOptions());
        Enumeration options = handler.listOptions();
        while (options.hasMoreElements()) {
            Option option = (Option)options.nextElement();
            if (option.name().trim().length() == 0) break;
            if (meta && option.name().trim().toLowerCase().equals(metaParameter.toLowerCase())) continue;
            ParameterType type = WekaTools.guessParameterType(option, defaultOptions);
            types.add(type);
            wekaParameters.add(type);
        }
    }

    public static JarFile getWekaJar() throws IOException {
        String wekaJar = System.getProperty("yale.weka.jar");
        if (wekaJar != null) {
            return new JarFile(new File(wekaJar));
        }
        return new JarFile(ParameterService.getLibraryFile("weka.jar"));
    }

    public static String[] getWekaClasses(Class superclass) {
        return WekaTools.getWekaClasses(superclass, null, true);
    }

    public static String[] getWekaClasses(Class superclass, String seachConstraint, boolean includeConstraint) {
        if (seachConstraint != null) {
            return WekaTools.getWekaClasses(superclass, new String[]{seachConstraint}, includeConstraint);
        }
        return WekaTools.getWekaClasses(superclass, null, includeConstraint);
    }

    public static String[] getWekaClasses(Class superclass, String[] searchConstraints, boolean positive) {
        if (positive) {
            return WekaTools.getWekaClasses(superclass, searchConstraints, null);
        }
        return WekaTools.getWekaClasses(superclass, null, searchConstraints);
    }

    public static String[] getWekaClasses(Class superclass, String[] positiveSearchConstraints, String[] negativeSearchConstraints) {
        JarFile jar = null;
        try {
            jar = WekaTools.getWekaJar();
        }
        catch (IOException e) {
            return new String[0];
        }
        LinkedList<String> classes = new LinkedList<String>();
        Tools.findImplementationsInJar(jar, superclass, classes);
        Iterator i = classes.iterator();
        block2: while (i.hasNext()) {
            int n;
            String name = (String)i.next();
            boolean removed = false;
            if (positiveSearchConstraints != null) {
                boolean shouldRemove = true;
                String[] stringArray = positiveSearchConstraints;
                n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String constraint = stringArray[n];
                    if (name.indexOf(constraint) != -1) {
                        shouldRemove = false;
                        break;
                    }
                    ++n;
                }
                if (shouldRemove) {
                    i.remove();
                    removed = true;
                }
            }
            if (removed || negativeSearchConstraints == null) continue;
            String[] stringArray = negativeSearchConstraints;
            int n3 = 0;
            n = stringArray.length;
            while (n3 < n) {
                String constraint = stringArray[n3];
                if (name.indexOf(constraint) != -1) {
                    i.remove();
                    continue block2;
                }
                ++n3;
            }
        }
        String[] names = new String[classes.size()];
        classes.toArray(names);
        return names;
    }

    public static void registerWekaOperators(ClassLoader classLoader, String[] classNames, String operatorClass, String firstDescription, String firstGroup, String icon) {
        WekaTools.registerWekaOperators(classLoader, classNames, new HashMap<String, String>(), operatorClass, firstDescription, firstGroup, icon);
    }

    public static void registerWekaOperators(ClassLoader classLoader, String[] classNames, Map<String, String> deprecationInfos, String operatorClass, String firstDescription, String firstGroup, String icon) {
        int i = 0;
        while (i < classNames.length) {
            String infoString = null;
            try {
                Class<?> clazz = Class.forName(classNames[i], true, classLoader);
                Object wekaObject = clazz.newInstance();
                Method method = clazz.getMethod("globalInfo", new Class[0]);
                infoString = (String)method.invoke(wekaObject, new Object[0]);
                if (infoString != null) {
                    infoString = WekaTools.htmlEscape(infoString, "&", "and");
                    infoString = WekaTools.htmlEscape(infoString, "_", "");
                    infoString = WekaTools.htmlEscape(infoString, "<i>", "");
                    infoString = WekaTools.htmlEscape(infoString, "</i>", "");
                    infoString = WekaTools.htmlEscape(infoString, "<b>", "");
                    infoString = WekaTools.htmlEscape(infoString, "</b>", "");
                    infoString = WekaTools.htmlEscape(infoString, "<tt>", "");
                    if ((infoString = WekaTools.htmlEscape(infoString, "</tt>", "")).indexOf("^") >= 0) {
                        infoString = infoString.substring(0, infoString.indexOf(".") + 1).trim();
                    }
                    if (infoString.indexOf("^") >= 0) {
                        infoString = null;
                    }
                } else {
                    LogService.logMessage("Delivered infoString from Weka is empty for '" + classNames[i] + "': using default short description.", 4);
                }
            }
            catch (ClassNotFoundException e) {
                LogService.logMessage("Cannot retrieve operator information from Weka for '" + classNames[i] + "': " + e, 4);
            }
            catch (InstantiationException e) {
                LogService.logMessage("Cannot retrieve operator information from Weka for '" + classNames[i] + "': " + e, 4);
            }
            catch (IllegalAccessException e) {
                LogService.logMessage("Cannot retrieve operator information from Weka for '" + classNames[i] + "': " + e, 4);
            }
            catch (ExceptionInInitializerError e) {
                LogService.logMessage("Cannot retrieve operator information from Weka for '" + classNames[i] + "': " + e, 4);
            }
            catch (NoClassDefFoundError e) {
                LogService.logMessage("Cannot retrieve operator information from Weka for '" + classNames[i] + "': " + e, 4);
            }
            catch (SecurityException e) {
                LogService.logMessage("Cannot retrieve operator information from Weka for '" + classNames[i] + "': " + e, 4);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
                LogService.logMessage("Cannot retrieve operator information from Weka for '" + classNames[i] + "': " + e, 4);
            }
            catch (InvocationTargetException e) {
                LogService.logMessage("Cannot retrieve operator information from Weka for '" + classNames[i] + "': " + e, 4);
            }
            int lastIndex = classNames[i].lastIndexOf(".");
            String name = classNames[i].substring(lastIndex + 1);
            String packageName = classNames[i].substring(0, lastIndex);
            String group = packageName.substring(packageName.lastIndexOf(".") + 1);
            String groupStart = group.substring(0, 1);
            String groupEnd = group.substring(1);
            group = String.valueOf(groupStart.toUpperCase()) + groupEnd.toLowerCase();
            try {
                String deprecationInfo = null;
                if (deprecationInfos != null) {
                    deprecationInfo = deprecationInfos.get(classNames[i]);
                }
                OperatorDescription description = new OperatorDescription(classLoader, name, operatorClass, infoString != null ? infoString : String.valueOf(firstDescription.trim()) + " " + name, firstGroup.endsWith(".") ? String.valueOf(firstGroup) + group : firstGroup, icon, deprecationInfo);
                description.createOperatorInstance();
                OperatorService.registerOperator(description);
            }
            catch (OperatorCreationException e) {
                LogService.logMessage("Cannot construct operator '" + name + "', error: " + e.getMessage(), 4);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
    }

    private static String htmlEscape(String toEscape, String what, String by) {
        String result = toEscape;
        int index = 0;
        int generalIndex = 0;
        while ((index = result.indexOf(what, generalIndex)) >= 0) {
            String first = result.substring(0, index);
            String last = result.substring(index + what.length());
            result = String.valueOf(first) + by + last;
            generalIndex = index + by.length();
        }
        return result;
    }
}

