/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.FastExample2SparseTransform;
import edu.udo.cs.yale.example.NominalAttributeStatistics;
import edu.udo.cs.yale.tools.Ontology;
import java.util.Enumeration;
import java.util.Iterator;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class WekaInstancesAdaptor
extends Instances {
    private static final long serialVersionUID = 99943154106235423L;
    public static final int LEARNING = 0;
    public static final int PREDICTING = 1;
    public static final int CLUSTERING = 2;
    public static final int ASSOCIATION_RULE_MINING = 3;
    public static final int WEIGHTING = 4;
    private ExampleSet exampleSet;
    private FastExample2SparseTransform exampleTransform;
    private int[] mostFrequent = null;
    private int taskType = 0;
    private Attribute labelAttribute = null;
    private Attribute weightAttribute = null;

    public WekaInstancesAdaptor(String name, ExampleSet exampleSet, int taskType) {
        super(name, WekaInstancesAdaptor.getAttributeVector(exampleSet, taskType), 0);
        this.exampleSet = exampleSet;
        this.taskType = taskType;
        this.weightAttribute = exampleSet.getAttributes().getWeight();
        this.exampleTransform = new FastExample2SparseTransform(exampleSet);
        switch (taskType) {
            case 0: {
                this.labelAttribute = exampleSet.getAttributes().getLabel();
                this.setClassIndex(exampleSet.getAttributes().size());
                break;
            }
            case 1: {
                this.labelAttribute = exampleSet.getAttributes().getPredictedLabel();
                this.setClassIndex(exampleSet.getAttributes().size());
                break;
            }
            case 2: {
                this.labelAttribute = null;
                this.setClassIndex(-1);
                break;
            }
            case 3: {
                exampleSet.recalculateAllAttributeStatistics();
                this.mostFrequent = new int[exampleSet.getAttributes().size()];
                int i = 0;
                for (Attribute attribute : exampleSet.getAttributes()) {
                    this.mostFrequent[i] = attribute.isNominal() ? ((NominalAttributeStatistics)attribute.getStatistics()).getMode() : -1;
                    ++i;
                }
                this.labelAttribute = null;
                this.setClassIndex(-1);
                break;
            }
            case 4: {
                this.labelAttribute = exampleSet.getAttributes().getLabel();
                if (this.labelAttribute == null) break;
                this.setClassIndex(exampleSet.getAttributes().size());
            }
        }
    }

    public Enumeration enumerateInstances() {
        return new InstanceEnumeration(this.exampleSet.iterator());
    }

    public Instance instance(int i) {
        return this.toWekaInstance(this.exampleSet.getExample(i));
    }

    public int numInstances() {
        return this.exampleSet.size();
    }

    private Instance toWekaInstance(Example example) {
        int numberOfRegularValues = example.getAttributes().size();
        int numberOfValues = numberOfRegularValues + (this.labelAttribute != null ? 1 : 0);
        double[] values = new double[numberOfValues];
        if (this.taskType == 3) {
            int a = 0;
            for (Attribute attribute : this.exampleSet.getAttributes()) {
                double value = example.getValue(attribute);
                if (attribute.isNominal() && value == (double)this.mostFrequent[a]) {
                    value = Double.NaN;
                }
                values[a] = value;
                ++a;
            }
        } else {
            int[] nonDefaultIndices = this.exampleTransform.getNonDefaultAttributeIndices(example);
            double[] nonDefaultValues = this.exampleTransform.getNonDefaultAttributeValues(example, nonDefaultIndices);
            int a = 0;
            while (a < nonDefaultIndices.length) {
                values[nonDefaultIndices[a]] = nonDefaultValues[a];
                ++a;
            }
        }
        switch (this.taskType) {
            case 0: {
                values[values.length - 1] = example.getValue(this.labelAttribute);
                break;
            }
            case 1: {
                values[values.length - 1] = Double.NaN;
                break;
            }
            case 4: {
                if (this.labelAttribute == null) break;
                values[values.length - 1] = example.getValue(this.labelAttribute);
                break;
            }
        }
        double weight = 1.0;
        if (this.weightAttribute != null) {
            weight = example.getValue(this.weightAttribute);
        }
        Instance instance = new Instance(weight, values);
        instance.setDataset((Instances)this);
        return instance;
    }

    private static FastVector getAttributeVector(ExampleSet exampleSet, int taskType) {
        Attribute label = null;
        switch (taskType) {
            case 0: 
            case 4: {
                label = exampleSet.getAttributes().getLabel();
                break;
            }
            case 1: {
                label = exampleSet.getAttributes().getPredictedLabel();
                break;
            }
        }
        FastVector attributeVector = new FastVector(exampleSet.getAttributes().size() + (label != null ? 1 : 0));
        for (Attribute attribute : exampleSet.getAttributes()) {
            attributeVector.addElement((Object)WekaInstancesAdaptor.toWekaAttribute(attribute));
        }
        if (label != null) {
            attributeVector.addElement((Object)WekaInstancesAdaptor.toWekaAttribute(label));
        }
        return attributeVector;
    }

    private static weka.core.Attribute toWekaAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        weka.core.Attribute result = null;
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 1)) {
            FastVector nominalValues = new FastVector(attribute.getMapping().getValues().size());
            int i = 0;
            while (i < attribute.getMapping().getValues().size()) {
                nominalValues.addElement((Object)attribute.getMapping().mapIndex(i));
                ++i;
            }
            result = new weka.core.Attribute(attribute.getName(), nominalValues);
        } else {
            result = new weka.core.Attribute(attribute.getName());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InstanceEnumeration
    implements Enumeration {
        private Iterator<Example> reader;

        public InstanceEnumeration(Iterator<Example> reader) {
            this.reader = reader;
        }

        public Object nextElement() {
            return WekaInstancesAdaptor.this.toWekaInstance(this.reader.next());
        }

        @Override
        public boolean hasMoreElements() {
            return this.reader.hasNext();
        }
    }
}

