/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.ParameterService;
import edu.udo.cs.yale.tools.ResourceSource;
import edu.udo.cs.yale.tools.plugin.Plugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final double IS_ZERO = 1.0E-8;
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.US);
    private static final NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance(Locale.US);
    private static final List<ResourceSource> ALL_RESOURCES = new LinkedList<ResourceSource>();
    public static final String RESOURCE_PREFIX = "edu/udo/cs/yale/resources/";
    public static final String[] TRUE_STRINGS = new String[]{"true", "on", "yes", "y"};
    public static final String[] FALSE_STRINGS = new String[]{"false", "off", "no", "n"};

    public static String formatPercent(double value) {
        if (Double.isNaN(value)) {
            return "?";
        }
        String percentDigitsString = System.getProperty("yale.gui.fractiondigits.percent");
        int percentDigits = 2;
        try {
            if (percentDigitsString != null) {
                percentDigits = Integer.parseInt(percentDigitsString);
            }
        }
        catch (NumberFormatException e) {
            LogService.logMessage("Bad integer for property 'yale.gui.fractiondigits.percent', using default number if digits (2).", 4);
        }
        PERCENT_FORMAT.setMaximumFractionDigits(percentDigits);
        PERCENT_FORMAT.setMinimumFractionDigits(percentDigits);
        return PERCENT_FORMAT.format(value);
    }

    public static String formatNumber(double value) {
        if (Double.isNaN(value)) {
            return "?";
        }
        int numberDigits = 3;
        try {
            String numberDigitsString = System.getProperty("yale.gui.fractiondigits.numbers");
            numberDigits = Integer.parseInt(numberDigitsString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        NUMBER_FORMAT.setMaximumFractionDigits(numberDigits);
        NUMBER_FORMAT.setMinimumFractionDigits(numberDigits);
        return NUMBER_FORMAT.format(value);
    }

    public static String formatNumber(double value, int numberOfDigits) {
        if (Double.isNaN(value)) {
            return "?";
        }
        int numberDigits = numberOfDigits;
        if (numberDigits < 0) {
            try {
                String numberDigitsString = System.getProperty("yale.gui.fractiondigits.numbers");
                numberDigits = Integer.parseInt(numberDigitsString);
            }
            catch (NumberFormatException e) {
                numberDigits = 3;
            }
        }
        NUMBER_FORMAT.setMaximumFractionDigits(numberDigits);
        NUMBER_FORMAT.setMinimumFractionDigits(numberDigits);
        return NUMBER_FORMAT.format(value);
    }

    public static String formatIntegerIfPossible(double value) {
        int numberDigits = 3;
        try {
            String numberDigitsString = System.getProperty("yale.gui.fractiondigits.numbers");
            numberDigits = Integer.parseInt(numberDigitsString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Tools.formatIntegerIfPossible(value, numberDigits);
    }

    public static String formatIntegerIfPossible(double value, int numberOfDigits) {
        if (Double.isNaN(value)) {
            return "?";
        }
        int intValue = (int)value;
        if ((double)intValue == value) {
            return String.valueOf(intValue);
        }
        return Tools.formatNumber(value, numberOfDigits);
    }

    public static final String ordinalNumber(int n) {
        if (n % 10 == 1 && n % 100 != 11) {
            return String.valueOf(n) + "st";
        }
        if (n % 10 == 2 && n % 100 != 12) {
            return String.valueOf(n) + "nd";
        }
        if (n % 10 == 3 && n % 100 != 13) {
            return String.valueOf(n) + "rd";
        }
        return String.valueOf(n) + "th";
    }

    public static boolean isZero(double d) {
        return Math.abs(d) < 1.0E-8;
    }

    public static boolean isEqual(double d1, double d2) {
        return Math.abs(d1 - d2) < 1.0E-8;
    }

    public static boolean isNotEqual(double d1, double d2) {
        return Math.abs(d1 - d2) > 1.0E-8;
    }

    public static String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static String getLineSeparators(int number) {
        if (number < 0) {
            number = 0;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < number) {
            result.append(LINE_SEPARATOR);
            ++i;
        }
        return result.toString();
    }

    public static String transformAllLineSeparators(String text) {
        Pattern crlf = Pattern.compile("(\r\n|\r|\n|\n\r)");
        Matcher m = crlf.matcher(text);
        if (m.find()) {
            text = m.replaceAll("\n");
        }
        return text;
    }

    public static String classNameWOPackage(Class c) {
        return c.getName().substring(c.getName().lastIndexOf(".") + 1);
    }

    public static String readOutput(BufferedReader in) throws IOException {
        StringBuffer output = new StringBuffer();
        String line = null;
        while ((line = in.readLine()) != null) {
            output.append(line);
            output.append(Tools.getLineSeparator());
        }
        return output.toString();
    }

    public static File getFile(File parent, String name) {
        if (name == null) {
            return null;
        }
        File file = new File(name);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(parent, name);
    }

    public static BufferedReader getReader(File file) throws IOException {
        if (file.getAbsolutePath().endsWith(".zip")) {
            ZipFile zipFile = new ZipFile(file);
            if (zipFile.size() == 0) {
                throw new IOException("Input of Zip file failed: the file archive does not contain any entries.");
            }
            if (zipFile.size() > 1) {
                throw new IOException("Input of Zip file failed: the file archive contains more than one entry.");
            }
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            InputStream zipIn = zipFile.getInputStream(entries.nextElement());
            return new BufferedReader(new InputStreamReader(zipIn));
        }
        if (file.getAbsolutePath().endsWith(".gz")) {
            return new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file))));
        }
        return new BufferedReader(new FileReader(file));
    }

    public static boolean mkdir(File dir) {
        if (dir == null) {
            return true;
        }
        if (dir.exists()) {
            return true;
        }
        File parent = dir.getParentFile();
        if (parent == null) {
            return true;
        }
        if (!parent.exists() && !Tools.mkdir(parent)) {
            return false;
        }
        return dir.mkdir();
    }

    public static String getRelativePath(File firstFile, File secondFile) throws IOException {
        String canonicalFirstPath = firstFile.getCanonicalPath();
        String canonicalSecondPath = secondFile.getCanonicalPath();
        int minLength = Math.min(canonicalFirstPath.length(), canonicalSecondPath.length());
        int index = 0;
        index = 0;
        while (index < minLength) {
            if (canonicalFirstPath.charAt(index) != canonicalSecondPath.charAt(index)) break;
            ++index;
        }
        String relPath = canonicalFirstPath;
        int lastSeparatorIndex = canonicalFirstPath.substring(0, index).lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            String absRest = canonicalSecondPath.substring(lastSeparatorIndex + 1);
            relPath = "";
            while (absRest.indexOf(File.separator) >= 0) {
                relPath = String.valueOf(relPath) + ".." + File.separator;
                absRest = absRest.substring(absRest.indexOf(File.separator) + 1);
            }
            relPath = String.valueOf(relPath) + canonicalFirstPath.substring(lastSeparatorIndex + 1);
        }
        return relPath;
    }

    public static void waitForProcess(Operator operator, Process process, String name) throws OperatorException {
        try {
            LogService.logMessage("Waiting for process '" + name + "' to die.", 0);
            int value = process.waitFor();
            if (value != 0) {
                throw new UserError(operator, 306, new Object[]{name, value});
            }
            LogService.logMessage("Process '" + name + "' terminated successfully.", 2);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for process '" + name + "' to die.", e);
        }
    }

    public static void sendEmail(String address, String subject, String content) {
        try {
            String command = System.getProperty("yale.tools.sendmail.command");
            if (command != null) {
                LogService.logMessage("Executing '" + command + "'", 0);
                Process sendmail = Runtime.getRuntime().exec(new String[]{command, address});
                PrintStream out = new PrintStream(sendmail.getOutputStream());
                out.println("Subject: " + subject);
                out.println("From: Yale");
                out.println("To: " + address);
                out.println();
                out.println(content);
                out.close();
                Tools.waitForProcess(null, sendmail, command);
            }
        }
        catch (Throwable e) {
            LogService.logException("Cannot send mail to " + address, null, e);
        }
    }

    public static void addResourceSource(ResourceSource source) {
        ALL_RESOURCES.add(source);
    }

    public static URL getResource(ClassLoader loader, String name) {
        return loader.getResource(RESOURCE_PREFIX + name);
    }

    public static URL getResource(String name) {
        URL resourceURL = Tools.getResource(Tools.class.getClassLoader(), name);
        if (resourceURL != null) {
            return resourceURL;
        }
        for (ResourceSource source : ALL_RESOURCES) {
            URL url = source.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public static String readTextFile(File file) throws IOException {
        return Tools.readTextFile(new FileReader(file));
    }

    public static String readTextFile(Reader r) throws IOException {
        StringBuffer contents = new StringBuffer();
        BufferedReader reader = new BufferedReader(r);
        String line = "";
        while ((line = reader.readLine()) != null) {
            contents.append(String.valueOf(line) + Tools.getLineSeparator());
        }
        reader.close();
        return contents.toString();
    }

    public static boolean booleanValue(String string, boolean deflt) {
        if (string == null) {
            return deflt;
        }
        string = string.toLowerCase().trim();
        int i = 0;
        while (i < TRUE_STRINGS.length) {
            if (TRUE_STRINGS[i].equals(string)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < FALSE_STRINGS.length) {
            if (FALSE_STRINGS[i].equals(string)) {
                return false;
            }
            ++i;
        }
        return deflt;
    }

    public static File findSourceFile(StackTraceElement e) {
        try {
            Class<?> clazz = Class.forName(e.getClassName());
            while (clazz.getDeclaringClass() != null) {
                clazz = clazz.getDeclaringClass();
            }
            String filename = clazz.getName().replace('.', File.separatorChar);
            return ParameterService.getSourceFile(String.valueOf(filename) + ".java");
        }
        catch (Throwable clazz) {
            String filename = e.getClassName().replace('.', File.separatorChar);
            return ParameterService.getSourceFile(String.valueOf(filename) + ".java");
        }
    }

    public static Process launchFileEditor(File file, int line) throws IOException {
        String editor = System.getProperty("yale.tools.editor");
        if (editor == null) {
            throw new IOException("Property 'yale.tools.editor' undefined.");
        }
        editor = editor.replaceAll("%f", file.getAbsolutePath());
        editor = editor.replaceAll("%l", String.valueOf(line));
        return Runtime.getRuntime().exec(editor);
    }

    public static String escapeXML(String string) {
        if (string == null) {
            return "null";
        }
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        return string;
    }

    public static void findImplementationsInJar(JarFile jar, Class superClass, List<String> implementations) {
        Tools.findImplementationsInJar(Tools.class.getClassLoader(), jar, superClass, implementations);
    }

    public static void findImplementationsInJar(ClassLoader loader, JarFile jar, Class<?> superClass, List<String> implementations) {
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String name = entry.getName();
            int dotClass = name.lastIndexOf(".class");
            if (dotClass < 0) continue;
            name = name.substring(0, dotClass);
            name = name.replaceAll("/", "\\.");
            try {
                Class<?> c = loader.loadClass(name);
                if (!superClass.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers())) continue;
                implementations.add(name);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Class classForName(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException var1_1) {
            try {
                return ClassLoader.getSystemClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException var1_2) {
                ** for (p : Plugin.getAllPlugins())
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                return p.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException var3_5) {
                // empty catch block
            }
            continue;
        }
lbl13:
        // 1 sources

        throw new ClassNotFoundException(className);
    }

    public static String[] mergeQuotedSplits(String line, String[] splittedTokens, String quoteString) throws IOException {
        LinkedList<String> tokens = new LinkedList<String>();
        int start = -1;
        int end = -1;
        int totalCounter = 0;
        int i = 0;
        while (i < splittedTokens.length) {
            if (splittedTokens[i].trim().startsWith(quoteString)) {
                start = i;
            }
            if (start >= 0) {
                StringBuffer current = new StringBuffer();
                while (end < 0 && i < splittedTokens.length) {
                    if (splittedTokens[i].endsWith(quoteString)) {
                        end = i;
                        break;
                    }
                    ++i;
                }
                if (end < 0) {
                    throw new IOException("Error during reading: open quote \" is not ended!");
                }
                String lastToken = null;
                int a = start;
                while (a <= end) {
                    String nextToken = splittedTokens[a];
                    if (nextToken.length() != 0) {
                        if (a == start) {
                            nextToken = nextToken.substring(1);
                        }
                        if (a == end) {
                            nextToken = nextToken.substring(0, nextToken.length() - 1);
                        }
                        if (lastToken != null) {
                            int lastIndex = line.indexOf(lastToken, totalCounter - lastToken.length()) + lastToken.length();
                            int thisIndex = line.indexOf(splittedTokens[a], totalCounter);
                            if (lastIndex >= 0 && thisIndex >= lastIndex) {
                                String separator = line.substring(lastIndex, thisIndex);
                                current.append(separator);
                            }
                        }
                        current.append(nextToken);
                        lastToken = splittedTokens[a];
                    }
                    ++a;
                }
                tokens.add(current.toString());
                start = -1;
                end = -1;
            } else {
                tokens.add(splittedTokens[i]);
            }
            totalCounter += splittedTokens[i].length();
            ++i;
        }
        String[] quoted = new String[tokens.size()];
        tokens.toArray(quoted);
        return quoted;
    }

    public static void getFirstToken(StreamTokenizer tokenizer) throws IOException {
        while (tokenizer.nextToken() == 10) {
        }
        if (tokenizer.ttype == 39 || tokenizer.ttype == 34) {
            tokenizer.ttype = -3;
        } else if (tokenizer.ttype == -3 && tokenizer.sval.equals("?")) {
            tokenizer.ttype = 63;
        }
    }

    public static void getLastToken(StreamTokenizer tokenizer, boolean endOfFileOk) throws IOException {
        if (!(tokenizer.nextToken() == 10 || tokenizer.ttype == -1 && endOfFileOk)) {
            throw new IOException("expected the end of the line " + tokenizer.lineno());
        }
    }

    public static void getNextToken(StreamTokenizer tokenizer) throws IOException {
        if (tokenizer.nextToken() == 10) {
            throw new IOException("unexpected end of line " + tokenizer.lineno());
        }
        if (tokenizer.ttype == -1) {
            throw new IOException("unexpected end of file in line " + tokenizer.lineno());
        }
        if (tokenizer.ttype == 39 || tokenizer.ttype == 34) {
            tokenizer.ttype = -3;
        } else if (tokenizer.ttype == -3 && tokenizer.sval.equals("?")) {
            tokenizer.ttype = 63;
        }
    }

    public static void waitForEOL(StreamTokenizer tokenizer) throws IOException {
        while (tokenizer.nextToken() != 10) {
        }
        tokenizer.pushBack();
    }
}

