/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.operator.ResultObject;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.LogService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class ResultService {
    private static PrintStream out = System.out;

    public static void init(String filename, Experiment experiment) {
        if (filename == null) {
            LogService.logMessage("No filename given for result file, using stdout for logging results!", 4);
            ResultService.init(System.out);
        } else if (filename.equals("stderr")) {
            ResultService.init(System.err);
        } else if (filename.equals("stdout")) {
            ResultService.init(System.out);
        } else {
            PrintStream out;
            File file = experiment.resolveFileName(filename);
            try {
                out = new PrintStream(new FileOutputStream(file));
            }
            catch (IOException e) {
                LogService.logMessage("Cannot create resultfile '" + filename + "': " + e.getClass() + ":" + e.getMessage(), 8);
                LogService.logMessage("using stdout", 8);
                out = System.out;
            }
            ResultService.init(out);
        }
    }

    public static void init(PrintStream outStream) {
        out = outStream;
    }

    public static void init(Experiment experiment) {
        String filename = null;
        try {
            filename = experiment.getRootOperator().getParameterAsString("resultfile");
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        ResultService.init(filename, experiment);
    }

    public static void close() {
        if (!System.out.equals(out) && !System.err.equals(out)) {
            out.close();
        }
    }

    public static void logResult(String result) {
        ResultService.logResult(result, out);
    }

    public static void logResult(String result, PrintStream localOut) {
        localOut.println(String.valueOf(ResultService.getTime()) + " " + result);
    }

    public static void logResult(ResultObject resultObject) {
        ResultService.logResult(resultObject, out);
    }

    public static void logResult(ResultObject resultObject, PrintStream localOut) {
        ResultService.logResult(resultObject.toResultString(), localOut);
    }

    private static String getTime() {
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance();
        String time = String.valueOf(ResultService.getTwoDigits(cal.get(5))) + "." + ResultService.getTwoDigits(cal.get(2) + 1) + "." + cal.get(1) + " " + ResultService.getTwoDigits(cal.get(11)) + ":" + ResultService.getTwoDigits(cal.get(12)) + ":" + ResultService.getTwoDigits(cal.get(13));
        return time;
    }

    static String getTwoDigits(int i) {
        return String.valueOf(i < 10 ? "0" : "") + i;
    }
}

