/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import java.util.Random;

public class RandomGenerator
extends Random {
    private static final long serialVersionUID = 7562534107359981433L;
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static RandomGenerator globalRandomGenerator;

    private RandomGenerator() {
    }

    public RandomGenerator(long seed) {
        super(seed);
    }

    public static RandomGenerator getGlobalRandomGenerator() {
        return RandomGenerator.getRandomGenerator(-1);
    }

    public static RandomGenerator getRandomGenerator(int seed) {
        if (seed < 0) {
            return globalRandomGenerator;
        }
        return new RandomGenerator(seed);
    }

    public static void init(Experiment experiment) {
        long seed = -1L;
        try {
            seed = experiment.getRootOperator().getParameterAsInt("random_seed");
        }
        catch (UndefinedParameterError e) {
            seed = 2001L;
        }
        globalRandomGenerator = seed == -1L ? new RandomGenerator() : new RandomGenerator(seed);
    }

    public double nextDoubleInRange(double lowerBound, double upperBound) {
        if (upperBound <= lowerBound) {
            throw new IllegalArgumentException("RandomGenerator.nextDoubleInRange : the upper bound of the random number range should be greater than the lower bound.");
        }
        return this.nextDouble() * (upperBound - lowerBound) + lowerBound;
    }

    public long nextLongInRange(long lowerBound, long upperBound) {
        if (upperBound <= lowerBound) {
            throw new IllegalArgumentException("RandomGenerator.nextLongInRange : the upper bound of the random number range should be greater than the lower bound.");
        }
        return (long)(this.nextDouble() * (double)(upperBound - lowerBound + 1L)) + lowerBound;
    }

    public int nextIntInRange(int lowerBound, int upperBound) {
        if (upperBound <= lowerBound) {
            throw new IllegalArgumentException("RandomGenerator.nextIntInRange : the upper bound of the random number range should be greater than the lower bound.");
        }
        return (int)(this.nextDouble() * (double)(upperBound - lowerBound + 1)) + lowerBound;
    }

    public String nextString(int length) {
        char[] chars = new char[length];
        int i = 0;
        while (i < chars.length) {
            chars[i] = ALPHABET.charAt(this.nextInt(ALPHABET.length()));
            ++i;
        }
        return new String(chars);
    }

    public int randomIndex(double[] probs) {
        double r = this.nextDouble();
        double sum = 0.0;
        int i = 0;
        while (i < probs.length) {
            if (r < (sum += probs[i])) {
                return i;
            }
            ++i;
        }
        return probs.length - 1;
    }
}

