/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.OperatorService;
import edu.udo.cs.yale.tools.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class ParameterService {
    public static void ensureYaleHomeSet() {
        String home = System.getProperty("yale.home");
        if (home != null) {
            LogService.logMessage("yale.home is '" + home + "'.", 3);
        } else {
            LogService.logMessage("Property yale.home is not set. Guessing.", 3);
            String classpath = System.getProperty("java.class.path");
            String[] pathComponents = classpath.split(File.pathSeparator);
            boolean found = false;
            int i = 0;
            while (i < pathComponents.length) {
                String path = pathComponents[i].trim();
                if (path.endsWith("yale.jar")) {
                    File jar = new File(path).getAbsoluteFile();
                    String message = "Trying parent directory of '" + jar + "'...";
                    File dir = jar.getParentFile();
                    if (dir != null) {
                        if ((dir = dir.getParentFile()) != null) {
                            message = String.valueOf(message) + "gotcha!";
                            System.setProperty("yale.home", dir.getAbsolutePath());
                        } else {
                            message = String.valueOf(message) + "failed";
                        }
                    } else {
                        message = String.valueOf(message) + "failed";
                    }
                    LogService.logMessage(message, 3);
                }
                ++i;
            }
            if (!found) {
                String message;
                block18: {
                    message = "Trying base directory of classes (build) '";
                    URL url = ParameterService.class.getClassLoader().getResource(".");
                    if (url != null) {
                        try {
                            File dir = new File(new URI(url.toString()));
                            if (dir != null) {
                                dir = dir.getParentFile();
                                message = String.valueOf(message) + dir + "'...";
                                if (dir != null) {
                                    message = String.valueOf(message) + "gotcha!";
                                    try {
                                        System.setProperty("yale.home", dir.getCanonicalPath());
                                    }
                                    catch (IOException e) {
                                        System.setProperty("yale.home", dir.getAbsolutePath());
                                    }
                                } else {
                                    message = String.valueOf(message) + "failed";
                                }
                                break block18;
                            }
                            message = String.valueOf(message) + "failed";
                        }
                        catch (URISyntaxException e) {
                            message = String.valueOf(message) + "failed";
                        }
                    } else {
                        message = String.valueOf(message) + "failed";
                    }
                }
                LogService.logMessage(message, 3);
            }
        }
        ParameterService.getProperty("yale.home");
    }

    public static void init() {
        ParameterService.init(null, true);
    }

    public static void init(InputStream operatorsXMLStream, boolean addWekaOperators) {
        String additionalOperators;
        ParameterService.loadRCFile();
        InputStream operatorDescriptionStream = operatorsXMLStream;
        if (operatorDescriptionStream == null) {
            URL operatorURL = Tools.getResource("operators.xml");
            try {
                if (operatorURL != null) {
                    operatorDescriptionStream = operatorURL.openStream();
                } else {
                    LogService.logMessage("Cannot find 'operators.xml'.", 6);
                }
            }
            catch (IOException e) {
                LogService.logMessage("Cannot read 'operators.xml'.", 6);
            }
        }
        if (operatorDescriptionStream != null) {
            OperatorService.registerOperators("operators.xml", operatorDescriptionStream, null, addWekaOperators);
        }
        if ((additionalOperators = System.getProperty("yale.operators.additional")) != null && additionalOperators.length() > 0) {
            String[] additionalOperatorFileNames = additionalOperators.split(File.pathSeparator);
            int i = 0;
            while (i < additionalOperatorFileNames.length) {
                File additionalOperatorFile = new File(additionalOperatorFileNames[i]);
                if (additionalOperatorFile.exists()) {
                    try {
                        OperatorService.registerOperators(additionalOperatorFile.getPath(), new FileInputStream(additionalOperatorFile), null, addWekaOperators);
                    }
                    catch (IOException e) {
                        LogService.logMessage("Cannot read '" + additionalOperatorFile + "'.", 6);
                    }
                } else {
                    LogService.logMessage("Cannot find operator description file '" + additionalOperatorFileNames[i] + "'", 6);
                }
                ++i;
            }
        }
    }

    public static File getUserConfigFile(String name) {
        return new File(ParameterService.getUserYaleDir(), name);
    }

    public static File getUserYaleDir() {
        File homeDir = new File(System.getProperty("user.home"));
        File userHomeDir = new File(homeDir, ".yale");
        if (!userHomeDir.exists()) {
            LogService.logMessage("Creating directory '" + userHomeDir + "'", 3);
            userHomeDir.mkdir();
        }
        return userHomeDir;
    }

    private static void loadRCFile() {
        File globalRC = ParameterService.getConfigFile("yalerc");
        ParameterService.loadAllRCFiles(globalRC.getPath());
        ParameterService.loadAllRCFiles(ParameterService.getUserConfigFile("yalerc").getAbsolutePath());
        ParameterService.loadAllRCFiles(new File(new File(System.getProperty("user.dir")), "yalerc").getAbsolutePath());
        String localRC = System.getProperty("yale.rcfile");
        if (localRC != null) {
            ParameterService.loadRCFile(localRC);
        } else {
            LogService.logMessage("Trying yale.rcfile. Property not specified...skipped", 3);
        }
    }

    private static void loadAllRCFiles(String rcFileName) {
        ParameterService.loadRCFile(rcFileName);
        ParameterService.loadRCFile(String.valueOf(rcFileName) + "." + System.getProperty("os.name"));
    }

    private static void loadRCFile(String rcFileName) {
        if (rcFileName == null) {
            return;
        }
        File rcFile = new File(rcFileName);
        if (!rcFile.exists()) {
            LogService.logMessage("Trying rcfile '" + rcFile + "'...skipped", 3);
            return;
        }
        try {
            FileInputStream in = new FileInputStream(rcFile);
            System.getProperties().load(in);
            ((InputStream)in).close();
            LogService.logMessage("Read rcfile '" + rcFile + "'.", 3);
            return;
        }
        catch (IOException e) {
            LogService.logMessage("Cannot load rcfile: " + rcFile, 6);
            return;
        }
    }

    private static String getProperty(String key) {
        String property = System.getProperty(key);
        if (property == null) {
            throw new RuntimeException("Property '" + key + "' not set!");
        }
        return property;
    }

    public static File getYaleHome() {
        return new File(ParameterService.getProperty("yale.home"));
    }

    public static File getConfigFile(String name) {
        File home = ParameterService.getYaleHome();
        return new File(home, "etc" + File.separator + name);
    }

    public static File getLibraryFile(String name) {
        File home = ParameterService.getYaleHome();
        return new File(home, "lib" + File.separator + name);
    }

    public static File getSampleFile(String filename) {
        File home = ParameterService.getYaleHome();
        return new File(home, "sample" + File.separator + filename);
    }

    public static File getSourceFile(String filename) {
        File home = ParameterService.getYaleHome();
        return new File(home, "src" + File.separator + filename);
    }

    public static File getPluginDir() {
        return ParameterService.getLibraryFile("plugins");
    }

    public static boolean booleanValue(String value, boolean deflt) {
        if (value == null) {
            return deflt;
        }
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("yes")) {
            return true;
        }
        if (value.equals("y")) {
            return true;
        }
        if (value.equals("on")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        if (value.equals("no")) {
            return false;
        }
        if (value.equals("n")) {
            return false;
        }
        if (value.equals("off")) {
            return false;
        }
        return deflt;
    }
}

