/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorCreationException;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.tools.GenericOperatorFactory;
import edu.udo.cs.yale.tools.GroupTree;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.WekaOperatorFactory;
import edu.udo.cs.yale.tools.XMLSerialization;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorService {
    private static Map<String, OperatorDescription> names2descriptions = new HashMap<String, OperatorDescription>();
    private static GroupTree groupTree = new GroupTree("");
    private static Map<String, Class<IOObject>> ioObjects = new TreeMap<String, Class<IOObject>>();

    public static void registerOperators(String name, InputStream operatorsXML, ClassLoader classLoader, boolean addWekaOperators) {
        if (classLoader == null) {
            classLoader = OperatorService.class.getClassLoader();
        }
        LogService.logMessage("Loading operators from '" + name + "'.", 3);
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(operatorsXML);
        }
        catch (Exception e) {
            LogService.logException("Cannot read operator description file '" + name + "': no valid XML!", null, e);
        }
        if (document != null) {
            if (!document.getDocumentElement().getTagName().toLowerCase().equals("operators")) {
                LogService.logMessage("Operator description file '" + name + "': outermost tag must be <operators>!", 6);
                return;
            }
            NodeList factoryTags = document.getDocumentElement().getElementsByTagName("factory");
            int i = 0;
            while (i < factoryTags.getLength()) {
                Element factoryTag = (Element)factoryTags.item(i);
                Attr classAttr = factoryTag.getAttributeNode("class");
                if (classAttr == null) {
                    LogService.logMessage("Operator description file '" + name + "': factory tag must provide class attribute!", 6);
                } else {
                    Class<?> factoryClass = null;
                    try {
                        factoryClass = classLoader.loadClass(classAttr.getValue());
                    }
                    catch (ClassNotFoundException e) {
                        LogService.logMessage("Operator factory class '" + classAttr.getValue() + "' not found!", 6);
                    }
                    if (factoryClass != null) {
                        if (GenericOperatorFactory.class.isAssignableFrom(factoryClass)) {
                            GenericOperatorFactory factory = null;
                            try {
                                factory = (GenericOperatorFactory)factoryClass.newInstance();
                            }
                            catch (Exception e) {
                                LogService.logMessage("Cannot instantiate operator factory class '" + factoryClass.getName() + "'!", 6);
                            }
                            if (factory != null && (addWekaOperators || !(factory instanceof WekaOperatorFactory))) {
                                factory.registerOperators(classLoader);
                            }
                        } else {
                            LogService.logMessage("Operator description file '" + name + "': only subclasses of GenericOperatorFactory may be defined as class, was '" + classAttr.getValue() + "'!", 6);
                        }
                    }
                }
                ++i;
            }
            NodeList operatorTags = document.getDocumentElement().getElementsByTagName("operator");
            int i2 = 0;
            while (i2 < operatorTags.getLength()) {
                Element currentElement = (Element)operatorTags.item(i2);
                try {
                    OperatorService.registerOperator(currentElement, classLoader);
                }
                catch (Exception e) {
                    Attr currentNameAttr = currentElement.getAttributeNode("name");
                    if (currentNameAttr != null) {
                        LogService.logMessage("Cannot register '" + currentNameAttr.getValue() + "': " + e, 6);
                    }
                    LogService.logMessage("Cannot register '" + currentElement + "': " + e, 6);
                }
                ++i2;
            }
        }
    }

    private static void registerOperator(Element operatorTag, ClassLoader classLoader) throws Exception {
        Attr nameAttr = operatorTag.getAttributeNode("name");
        Attr classAttr = operatorTag.getAttributeNode("class");
        if (nameAttr == null) {
            throw new Exception("Missing name for <operator> tag");
        }
        if (classAttr == null) {
            throw new Exception("Missing class for <operator> tag");
        }
        OperatorService.registerOperator(classLoader, nameAttr.getValue(), classAttr.getValue(), operatorTag.getAttribute("description"), operatorTag.getAttribute("group"), operatorTag.getAttribute("icon"), operatorTag.getAttribute("deprecation"));
    }

    private static void registerOperator(ClassLoader classLoader, String name, String clazz, String descr, String group, String icon, String deprecationInfo) throws Exception {
        OperatorService.registerOperator(new OperatorDescription(classLoader, name, clazz, descr, group, icon, deprecationInfo));
    }

    public static void registerOperator(OperatorDescription description) throws Exception {
        OperatorDescription oldDescription = names2descriptions.get(description.getName());
        if (oldDescription != null) {
            LogService.logMessage("An operator '" + description.getName() + "' was already registered. Overwriting...", 4);
        }
        names2descriptions.put(description.getName(), description);
        Operator currentOperator = description.createOperatorInstance();
        OperatorService.checkIOObjects(currentOperator.getInputClasses());
        OperatorService.checkIOObjects(currentOperator.getOutputClasses());
        String groupString = description.getGroup();
        String[] groupNames = groupString.split("\\.");
        GroupTree currentGroup = groupTree;
        int j = 0;
        while (j < groupNames.length) {
            String currentGroupName = groupNames[j].trim();
            if (currentGroupName.length() > 0) {
                GroupTree subGroup = currentGroup.getSubGroup(currentGroupName);
                if (subGroup == null) {
                    subGroup = new GroupTree(currentGroupName);
                    currentGroup.addSubGroup(subGroup);
                }
                currentGroup = subGroup;
            }
            ++j;
        }
        currentGroup.addOperatorDescription(description);
    }

    private static void checkIOObjects(Class[] objects) {
        LinkedList<Class<IOObject>> result = new LinkedList<Class<IOObject>>();
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                result.add(objects[i]);
                ++i;
            }
        }
        OperatorService.checkIOObjects(result);
    }

    private static void checkIOObjects(Collection<Class<IOObject>> objects) {
        for (Class<IOObject> currentClass : objects) {
            String current = currentClass.getName();
            ioObjects.put(current.substring(current.lastIndexOf(".") + 1), currentClass);
        }
    }

    public static Set<String> getIOObjectsNames() {
        return ioObjects.keySet();
    }

    public static void defineIOObjectXMLAliasPairs() {
        for (Map.Entry<String, Class<IOObject>> entry : ioObjects.entrySet()) {
            String objectName = entry.getKey();
            Class<IOObject> objectClass = entry.getValue();
            XMLSerialization.getXMLSerialization().addAlias(objectName, objectClass);
        }
    }

    public static Set<OperatorDescription> getOperatorsDelivering(Class ioObject) {
        HashSet<OperatorDescription> result = new HashSet<OperatorDescription>();
        for (String name : names2descriptions.keySet()) {
            OperatorDescription description = names2descriptions.get(name);
            try {
                Operator currentOperator = description.createOperatorInstance();
                if (!OperatorService.containsClass(currentOperator.getOutputClasses(), ioObject)) continue;
                result.add(description);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static Set<OperatorDescription> getOperatorsRequiring(Class ioObject) {
        HashSet<OperatorDescription> result = new HashSet<OperatorDescription>();
        for (String name : names2descriptions.keySet()) {
            OperatorDescription description = names2descriptions.get(name);
            try {
                Operator currentOperator = description.createOperatorInstance();
                if (!OperatorService.containsClass(currentOperator.getInputClasses(), ioObject)) continue;
                result.add(description);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static boolean containsClass(Class<?>[] types, Class<?> type) {
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                if (type.isAssignableFrom(types[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static Class<IOObject> getIOObjectClass(String name) {
        return ioObjects.get(name);
    }

    public static Set<String> getOperatorNames() {
        return names2descriptions.keySet();
    }

    public static GroupTree getGroups() {
        return groupTree;
    }

    public static OperatorDescription[] getOperatorDescriptions(Class clazz) {
        LinkedList<OperatorDescription> result = new LinkedList<OperatorDescription>();
        Iterator<String> i = names2descriptions.keySet().iterator();
        while (i.hasNext()) {
            OperatorDescription current = names2descriptions.get(i.next());
            if (!current.getOperatorClass().equals(clazz)) continue;
            result.add(current);
        }
        OperatorDescription[] resultArray = new OperatorDescription[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    public static OperatorDescription getOperatorDescription(String completeName) {
        return names2descriptions.get(completeName);
    }

    public static Operator createOperator(String className) throws OperatorCreationException {
        OperatorDescription description = names2descriptions.get(className);
        if (description == null) {
            throw new OperatorCreationException(4, className, null);
        }
        return OperatorService.createOperator(description);
    }

    public static Operator createOperator(OperatorDescription description) throws OperatorCreationException {
        return description.createOperatorInstance();
    }

    public static Operator createOperator(Class clazz) throws OperatorCreationException {
        OperatorDescription[] descriptions = OperatorService.getOperatorDescriptions(clazz);
        if (descriptions.length == 0) {
            throw new OperatorCreationException(4, clazz.getName(), null);
        }
        if (descriptions.length > 1) {
            throw new OperatorCreationException(5, clazz.getName(), null);
        }
        return descriptions[0].createOperatorInstance();
    }
}

