/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.ObjectVisualizer;
import edu.udo.cs.yale.gui.DummyObjectVisualizer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ObjectVisualizerService {
    private static final DummyObjectVisualizer DUMMY_VISUALIZER = new DummyObjectVisualizer();
    private static List<ObjectVisualizer> objectVisualizers = new LinkedList<ObjectVisualizer>();

    public static void addObjectVisualizer(ObjectVisualizer visualizer) {
        objectVisualizers.add(visualizer);
    }

    public static void removeObjectVisualizer(ObjectVisualizer visualizer) {
        objectVisualizers.remove(visualizer);
    }

    public static ObjectVisualizer getVisualizerForObject(String id) {
        Iterator<ObjectVisualizer> i = objectVisualizers.iterator();
        ObjectVisualizer capableVisualizer = DUMMY_VISUALIZER;
        while (i.hasNext()) {
            ObjectVisualizer visualizer = i.next();
            if (!visualizer.isCapableToVisualize(id)) continue;
            capableVisualizer = visualizer;
        }
        return capableVisualizer;
    }

    public static void clearVisualizers() {
        objectVisualizers.clear();
    }
}

