/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.NoBugError;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.log.DeleteLogFormatFilter;
import edu.udo.cs.yale.tools.log.DummyLogFormatFilter;
import edu.udo.cs.yale.tools.log.FormattedFilterStream;
import edu.udo.cs.yale.tools.log.StreamMultiplier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;

public class LogService {
    public static final int MINIMUM = 0;
    public static final int IO = 1;
    public static final int STATUS = 2;
    public static final int INIT = 3;
    public static final int WARNING = 4;
    public static final int EXCEPTION = 5;
    public static final int ERROR = 6;
    public static final int FATAL = 7;
    public static final int MAXIMUM = 8;
    public static final int OFF = 9;
    public static final String[] LOG_VERBOSITY_NAMES = new String[]{"minimum", "io", "status", "init", "warning", "exception", "error", "fatal", "maximum"};
    private static PrintStream logOut = System.out;
    private static int minVerbosityLevel = 3;
    private static String lastMessage;
    private static int equalMessageCount;
    private static File logFile;
    private static final String[] VERBOSITYLEVEL_START;
    private static final String[] VERBOSITYLEVEL_END;

    static {
        logFile = null;
        VERBOSITYLEVEL_START = new String[]{"", "", "", "", "$w$b[Warning]^b ", "$e$b[Exception]^b ", "$e$b[Error]^b ", "$e$b[Fatal]^b ", ""};
        VERBOSITYLEVEL_END = new String[]{"", "", "", "", "^w", "^e", "^e", "^e", ""};
    }

    public static void init(Experiment experiment) throws UndefinedParameterError {
        int verbosityLevel = experiment.getRootOperator().getParameterAsInt("logverbosity");
        LogService.init(experiment, verbosityLevel);
    }

    public static void init(Experiment experiment, int verbosityLevel) throws UndefinedParameterError {
        String filename = experiment.getRootOperator().getParameterAsString("logfile");
        if (filename == null) {
            LogService.logMessage("Logfile not set, using stdout", 4);
            logFile = null;
            LogService.init(System.out, verbosityLevel, false);
        } else if (filename.equals("stderr")) {
            logFile = null;
            LogService.init(System.err, verbosityLevel, false);
        } else if (filename.equals("stdout")) {
            logFile = null;
            LogService.init(System.out, verbosityLevel, false);
        } else {
            OutputStream out = null;
            logFile = experiment.resolveFileName(filename);
            try {
                out = new FileOutputStream(logFile);
            }
            catch (IOException e) {
                LogService.logMessage("Cannot create logfile '" + filename + "': " + e.getClass() + ":" + e.getMessage(), 8);
                LogService.logMessage("using stderr", 8);
                out = System.out;
            }
            LogService.init(out, verbosityLevel, false);
        }
    }

    public static void init(OutputStream out, int verbosityLevel, boolean format) {
        logOut = format ? new PrintStream(new FormattedFilterStream(out, new DummyLogFormatFilter())) : new PrintStream(new FormattedFilterStream(out, new DeleteLogFormatFilter()));
        minVerbosityLevel = verbosityLevel;
        LogService.logMessage("Started logging", 3);
        lastMessage = "";
        equalMessageCount = 0;
    }

    public static void initGUI() throws UndefinedParameterError {
        minVerbosityLevel = YaleGUI.getMainFrame().getExperiment().getRootOperator().getParameterAsInt("logverbosity");
        String logFileName = YaleGUI.getMainFrame().getExperiment().getRootOperator().getParameterAsString("logfile");
        if (logFileName != null) {
            try {
                logFile = YaleGUI.getMainFrame().getExperiment().resolveFileName(logFileName);
                logOut = new PrintStream(new StreamMultiplier(new FormattedFilterStream(new FileOutputStream(logFile), new DeleteLogFormatFilter()), new FormattedFilterStream(YaleGUI.getMainFrame().getMessageViewer().outputStream, new DummyLogFormatFilter())));
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot create log file: " + e);
            }
        } else {
            logOut = new PrintStream(YaleGUI.getMainFrame().getMessageViewer().outputStream);
        }
        LogService.logMessage("Log verbosity is: " + LOG_VERBOSITY_NAMES[minVerbosityLevel], 8);
    }

    public static void flush() {
        logOut.flush();
    }

    public static void setVerbosityLevel(int level) {
        minVerbosityLevel = level;
    }

    public static int getVerbosityLevel() {
        return minVerbosityLevel;
    }

    public static boolean isSufficientLogVerbosity(int level) {
        return level >= minVerbosityLevel;
    }

    public static void logMessage(String message, int verbosityLevel) {
        if (message == null) {
            return;
        }
        if (verbosityLevel < minVerbosityLevel) {
            return;
        }
        if (message.equals(lastMessage)) {
            ++equalMessageCount;
            return;
        }
        if (equalMessageCount > 0) {
            logOut.println("Last message repeated " + equalMessageCount + " times.");
            equalMessageCount = 0;
        }
        lastMessage = message;
        logOut.println(String.valueOf(LogService.getTime()) + " " + VERBOSITYLEVEL_START[verbosityLevel] + message + VERBOSITYLEVEL_END[verbosityLevel]);
    }

    public static void logMessageWithTree(String message, int verbosityLevel, Experiment experiment, Operator op) {
        if (verbosityLevel < minVerbosityLevel) {
            return;
        }
        String treeString = experiment.getRootOperator().createMarkedExperimentTree(10, " here ==> ", op);
        logOut.println("$m" + treeString + "^m");
        LogService.logMessage(message, verbosityLevel);
    }

    public static void logException(String message, Experiment experiment, Throwable exception) {
        if (5 < minVerbosityLevel) {
            return;
        }
        Operator op = null;
        if (experiment != null) {
            op = experiment.getCurrentOperator();
        }
        if (op != null) {
            LogService.logMessage(String.valueOf(Tools.classNameWOPackage(exception.getClass())) + " occured in " + Tools.ordinalNumber(op.getApplyCount()) + " application of " + op, 5);
        } else {
            LogService.logMessage(String.valueOf(Tools.classNameWOPackage(exception.getClass())) + " occured.", 5);
        }
        LogService.logMessage(exception.getMessage(), 5);
        if (message != null) {
            LogService.logMessage(message, 5);
        }
        if (!(exception instanceof NoBugError)) {
            exception.printStackTrace(logOut);
        }
    }

    private static String getTime() {
        return String.valueOf(DateFormat.getDateTimeInstance().format(new Date())) + ":";
    }

    public static File getLogFile() {
        return logFile;
    }
}

