/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.gui.templates.BuildingBlock;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.ParameterService;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildingBlockService {
    public static List<BuildingBlock> getBuildingBlocks() {
        List<BuildingBlock> buildingBlocks = BuildingBlockService.getPredefinedBuildingBlocks();
        buildingBlocks.addAll(BuildingBlockService.getUserBuildingBlocks());
        Collections.sort(buildingBlocks);
        return buildingBlocks;
    }

    public static List<BuildingBlock> getUserBuildingBlocks() {
        File[] userDefinedBuildingBlockFiles = ParameterService.getUserYaleDir().listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".buildingblock");
            }
        });
        LinkedList<BuildingBlock> buildingBlocks = new LinkedList<BuildingBlock>();
        File[] fileArray = userDefinedBuildingBlockFiles;
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File file = fileArray[n];
            try {
                buildingBlocks.add(new BuildingBlock(file));
            }
            catch (IOException e) {
                LogService.logMessage("Cannot load building block file '" + file + "': " + e.getMessage(), 6);
            }
            ++n;
        }
        return buildingBlocks;
    }

    public static List<BuildingBlock> getPredefinedBuildingBlocks() {
        File[] preDefinedBuildingBlockFiles = ParameterService.getConfigFile("buildingblocks").listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".buildingblock");
            }
        });
        LinkedList<BuildingBlock> buildingBlocks = new LinkedList<BuildingBlock>();
        File[] fileArray = preDefinedBuildingBlockFiles;
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File file = fileArray[n];
            try {
                buildingBlocks.add(new BuildingBlock(file));
            }
            catch (IOException e) {
                LogService.logMessage("Cannot load building block file '" + file + "': " + e.getMessage(), 6);
            }
            ++n;
        }
        return buildingBlocks;
    }
}

