/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.visualization.aggregation;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.InputDescription;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.operator.visualization.aggregation.AggregationFunction;
import edu.udo.cs.yale.operator.visualization.aggregation.AverageFunction;
import edu.udo.cs.yale.operator.visualization.aggregation.CountFunction;
import edu.udo.cs.yale.operator.visualization.aggregation.MaxFunction;
import edu.udo.cs.yale.operator.visualization.aggregation.MinFunction;
import edu.udo.cs.yale.operator.visualization.aggregation.SumFunction;
import edu.udo.cs.yale.operator.visualization.aggregation.VarianceFunction;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationOperator
extends Operator {
    private static final String AGGREGATION_NAME = "aggregation_function";
    private static final String ATTRIBUTE_NAME = "aggregation_attribute";
    private static final String GROUP_BY_NAME = "group_by_attribute";
    private static final String DISTINCT_NAME = "only_distinct";
    private static final Class[] KNOWN_AGGREGATION_FUNCTIONS = new Class[]{CountFunction.class, MinFunction.class, MaxFunction.class, SumFunction.class, AverageFunction.class, VarianceFunction.class};
    private static final String[] KNOWN_AGGREGATION_FUNCTION_NAMES = new String[]{"count", "min", "max", "sum", "average", "variance"};

    public AggregationOperator(OperatorDescription desc) {
        super(desc);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        AggregationFunction function;
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        try {
            function = this.createAggregationFunction();
        }
        catch (InstantiationException e) {
            throw new UserError((Operator)this, 904, this.getParameterAsString(AGGREGATION_NAME), (Object)e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new UserError((Operator)this, 904, this.getParameterAsString(AGGREGATION_NAME), (Object)e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new UserError((Operator)this, 904, this.getParameterAsString(AGGREGATION_NAME), (Object)e.getMessage());
        }
        String attributeName = this.getParameterAsString(ATTRIBUTE_NAME);
        Attribute aggregationAttribute = exampleSet.getAttributes().get(attributeName);
        if (aggregationAttribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString(ATTRIBUTE_NAME));
        }
        if (!function.supportsAttribute(aggregationAttribute)) {
            throw new UserError((Operator)this, 136, aggregationAttribute.getName());
        }
        LinkedList<Attribute> resultAttributes = new LinkedList<Attribute>();
        Attribute resultGroupAttribute = AttributeFactory.createAttribute("group", 1);
        resultAttributes.add(resultGroupAttribute);
        resultAttributes.add(AttributeFactory.createAttribute(String.valueOf(function.getName()) + "(" + aggregationAttribute.getName() + ")", 4));
        boolean onlyDistinct = this.getParameterAsBoolean(DISTINCT_NAME);
        MemoryExampleTable resultTable = new MemoryExampleTable(resultAttributes);
        if (this.isParameterSet(GROUP_BY_NAME)) {
            String groupByAttributeName = this.getParameterAsString(GROUP_BY_NAME);
            Attribute groupByAttribute = exampleSet.getAttributes().get(groupByAttributeName);
            if (groupByAttribute == null) {
                throw new UserError((Operator)this, 111, this.getParameterAsString(GROUP_BY_NAME));
            }
            if (!groupByAttribute.isNominal()) {
                throw new UserError((Operator)this, 103, new Object[]{this.getParameterAsString(GROUP_BY_NAME), "grouping by attribute."});
            }
            SplittedExampleSet grouped = SplittedExampleSet.splitByAttribute(exampleSet, groupByAttribute);
            int i = 0;
            while (i < grouped.getNumberOfSubsets()) {
                grouped.selectSingleSubset(i);
                double[] values = this.getValues(grouped, aggregationAttribute, onlyDistinct);
                double aggregationValue = function.calculate(values);
                double[] data = new double[]{resultGroupAttribute.getMapping().mapString(groupByAttribute.getMapping().mapIndex(i)), aggregationValue};
                resultTable.addDataRow(new DoubleArrayDataRow(data));
                ++i;
            }
        } else {
            double[] values = this.getValues(exampleSet, aggregationAttribute, onlyDistinct);
            double aggregationValue = function.calculate(values);
            double[] data = new double[]{resultGroupAttribute.getMapping().mapString("all"), aggregationValue};
            resultTable.addDataRow(new DoubleArrayDataRow(data));
        }
        ExampleSet resultSet = resultTable.createExampleSet();
        return new IOObject[]{resultSet};
    }

    private AggregationFunction createAggregationFunction() throws UndefinedParameterError, InstantiationException, IllegalAccessException, ClassNotFoundException {
        String functionName = this.getParameterAsString(AGGREGATION_NAME);
        int typeIndex = -1;
        int i = 0;
        while (i < KNOWN_AGGREGATION_FUNCTION_NAMES.length) {
            if (KNOWN_AGGREGATION_FUNCTION_NAMES[i].equals(functionName)) {
                typeIndex = i;
                break;
            }
            ++i;
        }
        Class clazz = null;
        clazz = typeIndex < 0 ? Class.forName(functionName) : KNOWN_AGGREGATION_FUNCTIONS[typeIndex];
        return (AggregationFunction)clazz.newInstance();
    }

    private double[] getValues(ExampleSet exampleSet, Attribute attribute, boolean onlyDistinct) {
        AbstractCollection valueCollection = new LinkedList();
        if (onlyDistinct) {
            valueCollection = new TreeSet();
        }
        for (Example e : exampleSet) {
            valueCollection.add(e.getValue(attribute));
        }
        double[] result = new double[valueCollection.size()];
        int counter = 0;
        Iterator iterator = valueCollection.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            result[counter++] = d;
        }
        return result;
    }

    @Override
    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, true, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{SplittedExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeStringCategory type = new ParameterTypeStringCategory(AGGREGATION_NAME, "The type of the used aggregation function.", KNOWN_AGGREGATION_FUNCTION_NAMES, KNOWN_AGGREGATION_FUNCTION_NAMES[0]);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString(ATTRIBUTE_NAME, "Applies the aggregation function on the attribute with this name.", false));
        types.add(new ParameterTypeString(GROUP_BY_NAME, "Performs a grouping by the values of the attribute with this name."));
        types.add(new ParameterTypeBoolean(DISTINCT_NAME, "Indicates if only rows with distinct values for the aggregation attribute should be used for the calculation of the aggregation function.", false));
        return types;
    }
}

