/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.visualization;

import edu.udo.cs.yale.datatable.DataTableExampleSetAdapter;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.plotter.PlotterPanel;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.ResultObjectAdapter;
import edu.udo.cs.yale.operator.visualization.SOMModelPlotter;
import java.awt.Component;

public class SOMModelVisualization
extends Operator {
    public SOMModelVisualization(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Model model = this.getInput(Model.class);
        return new IOObject[]{exampleSet, model, new ModelVisualization(exampleSet, model)};
    }

    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class, Model.class};
    }

    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class, Model.class};
    }

    private static class ModelVisualization
    extends ResultObjectAdapter {
        private ExampleSet exampleSet;
        private Model model;

        public ModelVisualization(ExampleSet exampleSet, Model model) {
            this.exampleSet = exampleSet;
            this.model = model;
        }

        public Component getVisualizationComponent(IOContainer container) {
            DataTableExampleSetAdapter table = new DataTableExampleSetAdapter(this.exampleSet, null);
            PlotterPanel panel = new PlotterPanel(table, PlotterPanel.MODEL_PLOTTER_SELECTION);
            SOMModelPlotter plotter = (SOMModelPlotter)panel.getSelectedPlotter();
            plotter.setDataTable(table);
            plotter.setExampleSet(this.exampleSet);
            plotter.setModel(this.model);
            return panel;
        }

        public String getName() {
            return "ModelVisualization";
        }

        public boolean isSavable() {
            return false;
        }

        public String getExtension() {
            return "mvs";
        }

        public String getFileDescription() {
            return "model visualization";
        }
    }
}

