/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.visualization;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.PredictionModel;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.math.LiftDataGenerator;
import java.util.List;

public class LiftChartGenerator
extends Operator {
    public LiftChartGenerator(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Model model = this.getInput(Model.class);
        if (exampleSet.getAttributes().getLabel() == null) {
            throw new UserError(this, 105);
        }
        if (!exampleSet.getAttributes().getLabel().isNominal()) {
            throw new UserError((Operator)this, 101, "Lift Charts", (Object)exampleSet.getAttributes().getLabel());
        }
        if (exampleSet.getAttributes().getLabel().getMapping().getValues().size() != 2) {
            throw new UserError((Operator)this, 114, "Lift Charts", (Object)exampleSet.getAttributes().getLabel());
        }
        if (exampleSet.getAttributes().getPredictedLabel() != null) {
            LogService.logMessage(String.valueOf(this.getName()) + ": input example already has a predicted label which will be removed.", 4);
            PredictionModel.removePredictedLabel(exampleSet);
        }
        model.apply(exampleSet);
        if (exampleSet.getAttributes().getPredictedLabel() == null) {
            throw new UserError(this, 107);
        }
        LiftDataGenerator liftDataGenerator = new LiftDataGenerator();
        List<double[]> liftPoints = liftDataGenerator.createLiftDataList(exampleSet);
        liftDataGenerator.createLiftChartPlot(liftPoints);
        PredictionModel.removePredictedLabel(exampleSet);
        return new IOObject[]{exampleSet, model};
    }

    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class, Model.class};
    }

    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class, Model.class};
    }
}

