/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.visualization;

import edu.udo.cs.yale.datatable.SimpleDataTable;
import edu.udo.cs.yale.datatable.SimpleDataTableRow;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeValue;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.LogService;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExperimentLogOperator
extends Operator {
    private static final Class[] OUTPUT_CLASSES = new Class[0];
    private String[] valueNames;

    public ExperimentLogOperator(OperatorDescription description) {
        super(description);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double fetchValue(String name, int column) throws UndefinedParameterError {
        StringTokenizer reader = new StringTokenizer(name, ".");
        String type = reader.nextToken();
        if (!type.equals("operator")) {
            LogService.logMessage(String.valueOf(this.getName()) + ": Unknown token '" + type + "' in '" + name + "'", 4);
            return Double.NaN;
        }
        String opName = reader.nextToken();
        Operator operator = this.getExperiment().getOperator(opName);
        if (operator == null) {
            LogService.logMessage(String.valueOf(this.getName()) + ": Unknown operator '" + opName + "' in '" + name + "'", 4);
            return Double.NaN;
        }
        type = reader.nextToken();
        if (type.equals("value")) {
            String valueName = reader.nextToken();
            double value = operator.getValue(valueName);
            if (!Double.isNaN(value)) return value;
            LogService.logMessage(String.valueOf(this.getName()) + ": No such value in '" + name + "'", 4);
            return Double.NaN;
        }
        if (!type.equals("parameter")) {
            LogService.logMessage(String.valueOf(this.getName()) + ": Unknown token '" + type + "' in '" + name + "'", 4);
            return Double.NaN;
        }
        String parameterName = reader.nextToken();
        ParameterType parameterType = operator.getParameterType(parameterName);
        if (parameterType == null) {
            LogService.logMessage(String.valueOf(this.getName()) + ": No such parameter in '" + name + "'", 4);
            return Double.NaN;
        }
        if (!parameterType.isNumerical()) {
            String value = parameterType.toString(operator.getParameter(parameterName));
            SimpleDataTable table = (SimpleDataTable)this.getExperiment().getDataTable(this.getName());
            return table.mapString(column, value);
        }
        try {
            return Double.parseDouble(operator.getParameter(parameterName).toString());
        }
        catch (NumberFormatException e) {
            LogService.logMessage(String.valueOf(this.getName()) + ": Cannot parse parameter value of '" + name + "'", 4);
            return Double.NaN;
        }
    }

    @Override
    public void experimentStarts() throws OperatorException {
        super.experimentStarts();
        List parameters = this.getParameterList("log");
        String[] columnNames = new String[parameters.size()];
        this.valueNames = new String[parameters.size()];
        Iterator i = parameters.iterator();
        int j = 0;
        while (i.hasNext()) {
            Object[] parameter = (Object[])i.next();
            columnNames[j] = (String)parameter[0];
            this.valueNames[j] = (String)parameter[1];
            ++j;
        }
        this.getExperiment().addDataTable(new SimpleDataTable(this.getName(), columnNames));
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        this.fetchAllValues();
        return new IOObject[0];
    }

    private void fetchAllValues() throws UndefinedParameterError {
        double[] row = new double[this.valueNames.length];
        int i = 0;
        while (i < this.valueNames.length) {
            double value;
            row[i] = value = this.fetchValue(this.valueNames[i], i);
            ++i;
        }
        this.getExperiment().getDataTable(this.getName()).add(new SimpleDataTableRow(row, null));
    }

    @Override
    public void experimentFinished() throws OperatorException {
        super.experimentFinished();
        File file = null;
        try {
            file = this.getParameterAsFile("filename");
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        if (file != null) {
            LogService.logMessage(String.valueOf(this.getName()) + ": writing data to '" + file.getName() + "'", 3);
            try {
                PrintWriter out = new PrintWriter(new FileWriter(file));
                this.getExperiment().getDataTable(this.getName()).write(out);
                out.close();
            }
            catch (IOException e) {
                LogService.logMessage(String.valueOf(this.getName()) + ": Could not write to file [" + file.getName() + "]", 6);
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterType type = new ParameterTypeFile("filename", "File to save the data to.", "log", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeList("log", "List of key value pairs where the key is the column name and the value specifies the experiment value to log.", new ParameterTypeValue("column_name", "operator.OPERATORNAME.[value|parameter].VALUE_NAME"));
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

