/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.visualization;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.visualization.CorrelationMatrix;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationMatrixOperator
extends Operator {
    public CorrelationMatrixOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        CorrelationMatrix matrix = new CorrelationMatrix(exampleSet);
        int numberOfAttributes = exampleSet.getAttributes().size();
        boolean squared = this.getParameterAsBoolean("squared_correlation");
        boolean createWeights = this.getParameterAsBoolean("create_weights");
        int k = 0;
        for (Attribute firstAttribute : exampleSet.getAttributes()) {
            int l = 0;
            for (Attribute secondAttribute : exampleSet.getAttributes()) {
                matrix.setValue(k, l, this.getCorrelation(exampleSet, firstAttribute, secondAttribute, squared || createWeights));
                this.checkForStop();
                ++l;
            }
            ++k;
        }
        if (createWeights) {
            AttributeWeights weights = new AttributeWeights();
            int i = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                double sum = 0.0;
                int j = 0;
                while (j < numberOfAttributes) {
                    sum += 1.0 - matrix.getValue(i, j);
                    ++j;
                }
                weights.setWeight(attribute.getName(), sum / (double)numberOfAttributes);
                ++i;
            }
            return new IOObject[]{exampleSet, weights};
        }
        return new IOObject[]{exampleSet, matrix};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        Class[] classArray;
        if (this.getParameterAsBoolean("create_weights")) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = ExampleSet.class;
            classArray = classArray2;
            classArray2[1] = AttributeWeights.class;
        } else {
            Class[] classArray3 = new Class[2];
            classArray3[0] = ExampleSet.class;
            classArray = classArray3;
            classArray3[1] = CorrelationMatrix.class;
        }
        return classArray;
    }

    private double getCorrelation(ExampleSet exampleSet, Attribute firstAttribute, Attribute secondAttribute, boolean squared) {
        double sumProd = 0.0;
        double sumFirst = 0.0;
        double sumSecond = 0.0;
        double sumFirstSquared = 0.0;
        double sumSecondSquared = 0.0;
        int counter = 0;
        for (Example example : exampleSet) {
            double second;
            double first = example.getValue(firstAttribute);
            double prod = first * (second = example.getValue(secondAttribute));
            if (Double.isNaN(prod)) continue;
            sumProd += prod;
            sumFirst += first;
            sumFirstSquared += first * first;
            sumSecond += second;
            sumSecondSquared += second * second;
            ++counter;
        }
        double r = ((double)counter * sumProd - sumFirst * sumSecond) / Math.sqrt(((double)counter * sumFirstSquared - sumFirst * sumFirst) * ((double)counter * sumSecondSquared - sumSecond * sumSecond));
        if (squared) {
            return r * r;
        }
        return r;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean("create_weights", "Indicates if attribute weights based on correlation should be calculated or if the complete matrix should be returned.", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("squared_correlation", "Indicates if the squared correlation should be calculated.", false));
        return types;
    }
}

