/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.visualization;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.datatable.DataTableCorrelationMatrixAdapter;
import edu.udo.cs.yale.datatable.DataTablePairwiseCorrelationAdapter;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.plotter.PlotterPanel;
import edu.udo.cs.yale.gui.viewer.DataTableViewer;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.ResultObjectAdapter;
import edu.udo.cs.yale.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class CorrelationMatrix
extends ResultObjectAdapter {
    private static final int MAX_NUMBER_OF_RESULT_STRING_ATTRIBUTES = 20;
    private double[][] matrix;
    private String[] columnNames;
    private NumberFormat formatter = NumberFormat.getInstance();

    public CorrelationMatrix(String[] columnNames) {
        this.formatter.setMaximumFractionDigits(3);
        this.formatter.setMinimumFractionDigits(3);
        this.columnNames = columnNames;
        this.matrix = new double[columnNames.length][columnNames.length];
    }

    public CorrelationMatrix(ExampleSet exampleSet) {
        this(CorrelationMatrix.getColumnNames(exampleSet));
    }

    private static String[] getColumnNames(ExampleSet exampleSet) {
        String[] attributeNames = new String[exampleSet.getAttributes().size()];
        int counter = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            attributeNames[counter++] = attribute.getName();
        }
        return attributeNames;
    }

    public void setValue(int i, int j, double value) {
        this.matrix[i][j] = value;
        this.matrix[j][i] = value;
    }

    public double getValue(int i, int j) {
        return this.matrix[i][j];
    }

    public int getNumberOfColumns() {
        return this.columnNames.length;
    }

    public String getName() {
        return "Correlation Matrix";
    }

    public String toString() {
        StringBuffer result = new StringBuffer("correlation matrix:" + Tools.getLineSeparator());
        int i = 0;
        while (i < this.columnNames.length) {
            if (i >= 20) {
                result.append("...");
                break;
            }
            result.append("\t" + this.columnNames[i]);
            ++i;
        }
        i = 0;
        while (i < this.matrix.length) {
            if (i >= 20) {
                result.append(String.valueOf(Tools.getLineSeparator()) + "...");
                break;
            }
            result.append(String.valueOf(Tools.getLineSeparator()) + this.columnNames[i]);
            int j = 0;
            while (j < this.matrix[i].length) {
                if (j >= 20) {
                    result.append("...");
                    break;
                }
                result.append("\t" + this.formatter.format(this.matrix[i][j]));
                ++j;
            }
            ++i;
        }
        return result.toString();
    }

    private DataTable createMatrixDataTable() {
        return new DataTableCorrelationMatrixAdapter(this, this.columnNames);
    }

    private DataTable createPairwiseCorrelationDataTable() {
        return new DataTablePairwiseCorrelationAdapter(this, this.columnNames);
    }

    public String getExtension() {
        return "cor";
    }

    public String getFileDescription() {
        return "correlation matrix";
    }

    public Component getVisualizationComponent(IOContainer container) {
        final JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        DataTable matrixDataTable = this.createMatrixDataTable();
        final DataTableViewer matrixTableViewer = new DataTableViewer(matrixDataTable);
        matrixTableViewer.getTable().setAutoResizeMode(0);
        matrixTableViewer.getTable().setRendererType(2);
        DataTable pairwiseDataTable = this.createPairwiseCorrelationDataTable();
        final DataTableViewer pairwiseTableViewer = new DataTableViewer(pairwiseDataTable);
        final PlotterPanel plotterComponent = new PlotterPanel(pairwiseDataTable);
        final JRadioButton matrixButton = new JRadioButton("matrix", true);
        matrixButton.setToolTipText("Changes to a table showing information about all correlations.");
        matrixButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (matrixButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)matrixTableViewer, "Center");
                    mainPanel.repaint();
                }
            }
        });
        final JRadioButton pairwiseButton = new JRadioButton("pairwise correlations", true);
        pairwiseButton.setToolTipText("Changes to a table showing the correlations for all pairs.");
        pairwiseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (pairwiseButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)pairwiseTableViewer, "Center");
                    mainPanel.repaint();
                }
            }
        });
        final JRadioButton plotButton = new JRadioButton("plot view", false);
        plotButton.setToolTipText("Changes to a plot view of the correlation data.");
        plotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (plotButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)plotterComponent, "Center");
                    mainPanel.repaint();
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(matrixButton);
        group.add(pairwiseButton);
        group.add(plotButton);
        JPanel togglePanel = new JPanel(new FlowLayout(0));
        togglePanel.add(matrixButton);
        togglePanel.add(pairwiseButton);
        togglePanel.add(plotButton);
        mainPanel.add((Component)togglePanel, "North");
        mainPanel.add((Component)matrixTableViewer, "Center");
        return mainPanel;
    }
}

