/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation.significance;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.math.SignificanceTestResult;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SignificanceTestOperator
extends Operator {
    public SignificanceTestOperator(OperatorDescription description) {
        super(description);
    }

    public abstract SignificanceTestResult performSignificanceTest(PerformanceVector[] var1, double var2) throws OperatorException;

    public abstract int getMinSize();

    public abstract int getMaxSize();

    @Override
    public IOObject[] apply() throws OperatorException {
        LinkedList<PerformanceVector> allVectors = new LinkedList<PerformanceVector>();
        boolean ok = true;
        while (ok) {
            try {
                PerformanceVector pv = this.getInput(PerformanceVector.class);
                allVectors.add(pv);
            }
            catch (MissingIOObjectException e) {
                ok = false;
            }
        }
        if (allVectors.size() < this.getMinSize()) {
            throw new UserError((Operator)this, 123, PerformanceVector.class, (Object)String.valueOf(this.getMinSize()));
        }
        if (allVectors.size() > this.getMaxSize()) {
            throw new UserError((Operator)this, 124, PerformanceVector.class, (Object)String.valueOf(this.getMaxSize()));
        }
        PerformanceVector[] allVectorsArray = new PerformanceVector[allVectors.size()];
        allVectors.toArray(allVectorsArray);
        SignificanceTestResult result = this.performSignificanceTest(allVectorsArray, this.getParameterAsDouble("alpha"));
        IOObject[] resultArray = new IOObject[allVectors.size() + 1];
        System.arraycopy(allVectorsArray, 0, resultArray, 0, allVectorsArray.length);
        resultArray[resultArray.length - 1] = result;
        return resultArray;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{PerformanceVector.class, SignificanceTestResult.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble("alpha", "The probability threshold which determines if differences are considered as significant.", 0.0, 1.0, 0.05));
        return types;
    }
}

