/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation.significance;

import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.operator.validation.significance.SignificanceTestOperator;
import edu.udo.cs.yale.tools.math.AnovaCalculator;
import edu.udo.cs.yale.tools.math.SignificanceCalculationException;
import edu.udo.cs.yale.tools.math.SignificanceTestResult;

public class AnovaSignificanceTestOperator
extends SignificanceTestOperator {
    public AnovaSignificanceTestOperator(OperatorDescription description) {
        super(description);
    }

    public SignificanceTestResult performSignificanceTest(PerformanceVector[] allVectors, double alpha) throws OperatorException {
        AnovaCalculator calculator = new AnovaCalculator();
        calculator.setAlpha(alpha);
        int i = 0;
        while (i < allVectors.length) {
            PerformanceCriterion pc = allVectors[i].getMainCriterion();
            calculator.addGroup(pc.getExampleCount(), pc.getAverage(), pc.getVariance());
            ++i;
        }
        try {
            return calculator.performSignificanceTest();
        }
        catch (SignificanceCalculationException e) {
            throw new UserError((Operator)this, 920, e.getMessage());
        }
    }

    public int getMinSize() {
        return 2;
    }

    public int getMaxSize() {
        return Integer.MAX_VALUE;
    }
}

