/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.operator.validation.WrapperValidationChain;
import edu.udo.cs.yale.tools.LogService;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperXValidation
extends WrapperValidationChain {
    private int number;
    private int iteration;

    public WrapperXValidation(OperatorDescription description) {
        super(description);
        this.addValue(new Value("iteration", "The number of the current iteration."){

            public double getValue() {
                return WrapperXValidation.this.iteration;
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet eSet = this.getInput(ExampleSet.class);
        this.number = this.getParameterAsBoolean("leave_one_out") ? eSet.size() : this.getParameterAsInt("number_of_validations");
        int samplingType = this.getParameterAsInt("sampling_type");
        int randomSeed = this.getParameterAsInt("local_random_seed");
        SplittedExampleSet inputSet = new SplittedExampleSet(eSet, this.number, samplingType, randomSeed);
        LogService.logMessage(String.valueOf(this.getName()) + ": Starting " + this.number + "-fold method cross validation", 2);
        PerformanceVector performanceVector = null;
        AttributeWeights globalWeights = new AttributeWeights();
        for (Attribute attribute : eSet.getAttributes()) {
            globalWeights.setWeight(attribute.getName(), 0.0);
        }
        this.iteration = 0;
        while (this.iteration < this.number) {
            inputSet.selectAllSubsetsBut(this.iteration);
            AttributeWeights weights = this.useMethod(inputSet).remove(AttributeWeights.class);
            SplittedExampleSet newInputSet = (SplittedExampleSet)inputSet.clone();
            this.learn(new AttributeWeightedExampleSet(newInputSet, weights, 0.0).createCleanClone());
            newInputSet.selectSingleSubset(this.iteration);
            IOContainer evalOutput = this.evaluate(new AttributeWeightedExampleSet(newInputSet, weights, 0.0).createCleanClone());
            PerformanceVector iterationPerformance = evalOutput.remove(PerformanceVector.class);
            if (performanceVector == null) {
                performanceVector = iterationPerformance;
            } else {
                int i = 0;
                while (i < performanceVector.size()) {
                    performanceVector.getCriterion(i).buildAverage(iterationPerformance.getCriterion(i));
                    ++i;
                }
            }
            this.handleWeights(globalWeights, weights);
            this.setResult(iterationPerformance.getMainCriterion());
            this.inApplyLoop();
            ++this.iteration;
        }
        for (String currentName : globalWeights.getAttributeNames()) {
            globalWeights.setWeight(currentName, globalWeights.getWeight(currentName) / (double)this.number);
        }
        this.setResult(performanceVector.getMainCriterion());
        return new IOObject[]{performanceVector, globalWeights};
    }

    private void handleWeights(AttributeWeights globalWeights, AttributeWeights currentWeights) {
        for (String currentName : currentWeights.getAttributeNames()) {
            double globalWeight = globalWeights.getWeight(currentName);
            double currentWeight = currentWeights.getWeight(currentName);
            if (Double.isNaN(globalWeight)) {
                globalWeights.setWeight(currentName, currentWeight);
                continue;
            }
            globalWeights.setWeight(currentName, globalWeight + currentWeight);
        }
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{PerformanceVector.class, AttributeWeights.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("number_of_validations", "Number of subsets for the crossvalidation", 2, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("leave_one_out", "Set the number of validations to the number of examples. If set to true, number_of_validations is ignored", false));
        types.add(new ParameterTypeCategory("sampling_type", "Defines the sampling type of the cross validation (linear = consecutive subsets, shuffled = random subsets, stratified = random subsets with class distribution kept constant)", SplittedExampleSet.SAMPLING_NAMES, 2));
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global)", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

