/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation;

import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.condition.CombinedInnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.SpecificInnerOperatorCondition;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.operator.performance.PerformanceVector;

public abstract class WrapperValidationChain
extends OperatorChain {
    private static final Class[] OUTPUT_CLASSES = new Class[]{PerformanceVector.class, AttributeWeights.class};
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private PerformanceCriterion lastPerformance;
    private IOContainer learnResult;
    private IOContainer methodResult;

    public WrapperValidationChain(OperatorDescription description) {
        super(description);
        this.addValue(new Value("performance", "The last performance (main criterion)."){

            public double getValue() {
                if (WrapperValidationChain.this.lastPerformance != null) {
                    return WrapperValidationChain.this.lastPerformance.getAverage();
                }
                return Double.NaN;
            }
        });
        this.addValue(new Value("variance", "The variance of the last performance (main criterion)."){

            public double getValue() {
                if (WrapperValidationChain.this.lastPerformance != null) {
                    return WrapperValidationChain.this.lastPerformance.getVariance();
                }
                return Double.NaN;
            }
        });
    }

    public int getMaxNumberOfInnerOperators() {
        return 3;
    }

    public int getMinNumberOfInnerOperators() {
        return 3;
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public InnerOperatorCondition getInnerOperatorCondition() {
        CombinedInnerOperatorCondition condition = new CombinedInnerOperatorCondition();
        condition.addCondition(new SpecificInnerOperatorCondition("Wrapper", 0, new Class[]{ExampleSet.class}, new Class[]{AttributeWeights.class}));
        condition.addCondition(new SpecificInnerOperatorCondition("Training", 1, new Class[]{ExampleSet.class}, new Class[]{Model.class}));
        condition.addCondition(new SpecificInnerOperatorCondition("Testing", 2, new Class[]{ExampleSet.class, Model.class}, new Class[]{PerformanceVector.class}));
        return condition;
    }

    private Operator getMethod() {
        return this.getOperator(0);
    }

    private Operator getLearner() {
        return this.getOperator(1);
    }

    private Operator getEvaluator() {
        return this.getOperator(2);
    }

    void setResult(PerformanceCriterion pc) {
        this.lastPerformance = pc;
    }

    IOContainer useMethod(ExampleSet methodTrainingSet) throws OperatorException {
        this.methodResult = this.getMethod().apply(new IOContainer(new IOObject[]{methodTrainingSet}));
        return this.methodResult;
    }

    IOContainer learn(ExampleSet trainingSet) throws OperatorException {
        if (this.methodResult == null) {
            throw new RuntimeException("Wrong use of MethodEvaluator.evaluate(ExampleSet): No preceding invocation of useMethod(ExampleSet)!");
        }
        this.learnResult = this.getLearner().apply(new IOContainer(new IOObject[]{trainingSet}));
        this.methodResult = null;
        return this.learnResult;
    }

    IOContainer evaluate(ExampleSet testSet) throws OperatorException {
        if (this.learnResult == null) {
            throw new RuntimeException("Wrong use of ValidationChain.evaluate(ExampleSet): No preceding invocation of learn(ExampleSet)!");
        }
        IOContainer result = this.getEvaluator().apply(this.learnResult.append(new IOObject[]{testSet}));
        this.learnResult = null;
        return result;
    }
}

