/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.InputDescription;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.condition.CombinedInnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.SpecificInnerOperatorCondition;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValidationChain
extends OperatorChain {
    private PerformanceCriterion lastPerformance;
    private IOContainer learnResult;

    public ValidationChain(OperatorDescription description) {
        super(description);
        this.addValue(new Value("performance", "The last performance average (main criterion)."){

            public double getValue() {
                if (ValidationChain.this.lastPerformance != null) {
                    return ValidationChain.this.lastPerformance.getAverage();
                }
                return Double.NaN;
            }
        });
        this.addValue(new Value("variance", "The variance of the last performance (main criterion)."){

            public double getValue() {
                if (ValidationChain.this.lastPerformance != null) {
                    return ValidationChain.this.lastPerformance.getVariance();
                }
                return Double.NaN;
            }
        });
        this.addValue(new Value("deviation", "The standard deviation of the last performance (main criterion)."){

            public double getValue() {
                if (ValidationChain.this.lastPerformance != null) {
                    return ValidationChain.this.lastPerformance.getStandardDeviation();
                }
                return Double.NaN;
            }
        });
    }

    public abstract IOObject[] estimatePerformance(ExampleSet var1) throws OperatorException;

    @Override
    public int getMaxNumberOfInnerOperators() {
        return 2;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 2;
    }

    @Override
    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        if (this.getParameterAsBoolean("create_complete_model")) {
            return new Class[]{PerformanceVector.class, Model.class};
        }
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        CombinedInnerOperatorCondition condition = new CombinedInnerOperatorCondition();
        condition.addCondition(new SpecificInnerOperatorCondition("Training", 0, new Class[]{ExampleSet.class}, new Class[]{Model.class}));
        condition.addCondition(new SpecificInnerOperatorCondition("Testing", 1, new Class[]{ExampleSet.class, Model.class}, new Class[]{PerformanceVector.class}));
        return condition;
    }

    private Operator getLearner() {
        return this.getOperator(0);
    }

    private Operator getEvaluator() {
        return this.getOperator(1);
    }

    protected void setResult(PerformanceCriterion pc) {
        this.lastPerformance = pc;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        IOObject[] estimation;
        ExampleSet eSet = this.getInput(ExampleSet.class);
        IOObject[] result = estimation = this.estimatePerformance(eSet);
        if (this.getParameterAsBoolean("create_complete_model")) {
            Model model = this.getLearner().apply(new IOContainer(new IOObject[]{eSet})).get(Model.class);
            result = new IOObject[estimation.length + 1];
            System.arraycopy(estimation, 0, result, 0, estimation.length);
            result[result.length - 1] = model;
        }
        return result;
    }

    protected IOContainer learn(ExampleSet trainingSet) throws OperatorException {
        this.learnResult = this.getLearner().apply(new IOContainer(new IOObject[]{trainingSet}));
        return this.learnResult;
    }

    protected IOContainer evaluate(ExampleSet testSet) throws OperatorException {
        if (this.learnResult == null) {
            throw new RuntimeException("Wrong use of ValidationChain.evaluate(ExampleSet): No preceding invocation of learn(ExampleSet)!");
        }
        Attribute predictedBefore = testSet.getAttributes().getPredictedLabel();
        IOContainer evalInput = this.learnResult.append(new IOObject[]{testSet});
        IOContainer result = this.getEvaluator().apply(evalInput);
        Attribute predictedAfter = testSet.getAttributes().getPredictedLabel();
        if (predictedAfter != null && (predictedBefore == null || predictedBefore.getTableIndex() != predictedAfter.getTableIndex())) {
            if (predictedAfter.isNominal()) {
                for (String value : predictedAfter.getMapping().getValues()) {
                    Attribute currentConfidenceAttribute = testSet.getAttributes().getSpecial("confidence(" + value + ")");
                    if (currentConfidenceAttribute == null) continue;
                    testSet.getAttributes().remove(currentConfidenceAttribute);
                    testSet.getExampleTable().removeAttribute(currentConfidenceAttribute);
                }
            }
            testSet.getAttributes().remove(predictedAfter);
            testSet.getExampleTable().removeAttribute(predictedAfter);
        }
        this.learnResult = null;
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean("create_complete_model", "Indicates if a model of the complete data set should be additionally build after estimation.", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

