/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation;

import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.math.AverageVector;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools {
    public static void handleAverages(IOContainer evalOutput, List<AverageVector> averageVectors) throws OperatorException {
        Tools.handleAverages(evalOutput, averageVectors, true);
    }

    public static void handleAverages(IOContainer evalOutput, List<AverageVector> averageVectors, boolean onlyPerformanceVectors) throws OperatorException {
        Class<AverageVector> requestClass = AverageVector.class;
        if (onlyPerformanceVectors) {
            requestClass = PerformanceVector.class;
        }
        if (averageVectors.size() == 0) {
            boolean inputOk = true;
            while (inputOk) {
                try {
                    AverageVector currentAverage = evalOutput.remove(requestClass);
                    averageVectors.add(currentAverage);
                }
                catch (MissingIOObjectException e) {
                    inputOk = false;
                }
            }
        } else {
            int n = 0;
            while (n < averageVectors.size()) {
                AverageVector currentAverage = evalOutput.remove(requestClass);
                AverageVector oldVector = averageVectors.get(n);
                if (!oldVector.getClass().isInstance(currentAverage)) {
                    throw new OperatorException("ValidationChain: Average vector mismatch! Fatal error...");
                }
                int i = 0;
                while (i < oldVector.size()) {
                    oldVector.getAveragable(i).buildAverage(currentAverage.getAveragable(i));
                    ++i;
                }
                ++n;
            }
        }
    }

    public static PerformanceVector getPerformanceVector(List<AverageVector> averageVectors) {
        for (AverageVector currentAverage : averageVectors) {
            if (!(currentAverage instanceof PerformanceVector)) continue;
            return (PerformanceVector)currentAverage;
        }
        return null;
    }
}

