/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.Partition;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.operator.validation.Tools;
import edu.udo.cs.yale.operator.validation.ValidationChain;
import edu.udo.cs.yale.tools.math.AverageVector;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlidingWindowValidation
extends ValidationChain {
    public SlidingWindowValidation(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] estimatePerformance(ExampleSet inputSet) throws OperatorException {
        int[] partition;
        int horizon;
        int neededSize;
        int trainingWindowWidth = this.getParameterAsInt("training_window_width");
        int testWindowWidth = this.getParameterAsInt("test_window_width");
        int stepSize = this.getParameterAsInt("training_window_step_size");
        if (stepSize < 0) {
            stepSize = testWindowWidth;
        }
        if ((neededSize = trainingWindowWidth + (horizon = this.getParameterAsInt("horizon") - 1) + testWindowWidth) > (partition = new int[inputSet.size()]).length) {
            String reason = "(" + trainingWindowWidth + "+" + horizon + "+" + testWindowWidth + "=" + neededSize + ")";
            throw new UserError((Operator)this, 110, reason);
        }
        ArrayList<AverageVector> averageVectors = new ArrayList<AverageVector>();
        int trainingStart = 0;
        while (trainingStart < partition.length) {
            if (trainingStart + trainingWindowWidth + horizon + testWindowWidth > partition.length) break;
            int i = 0;
            while (i < partition.length) {
                partition[i] = i >= trainingStart && i < trainingStart + trainingWindowWidth ? 0 : (i >= trainingStart + trainingWindowWidth + horizon && i < trainingStart + trainingWindowWidth + horizon + testWindowWidth ? 1 : 2);
                ++i;
            }
            SplittedExampleSet splittedES = new SplittedExampleSet(inputSet, new Partition(partition, 3));
            splittedES.selectSingleSubset(0);
            this.learn(splittedES);
            splittedES.selectSingleSubset(1);
            IOContainer evalOutput = this.evaluate(splittedES);
            Tools.handleAverages(evalOutput, averageVectors, this.getParameterAsBoolean("average_performances_only"));
            this.inApplyLoop();
            trainingStart += stepSize;
        }
        PerformanceVector averagePerformance = Tools.getPerformanceVector(averageVectors);
        if (averagePerformance != null) {
            this.setResult(averagePerformance.getMainCriterion());
        }
        IOObject[] result = new AverageVector[averageVectors.size()];
        averageVectors.toArray(result);
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("training_window_width", "Number of examples in the window which is used for training", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("training_window_step_size", "Number of examples the window is moved after each iteration (-1: same as test window width)", -1, Integer.MAX_VALUE, -1);
        types.add(type);
        type = new ParameterTypeInt("test_window_width", "Number of examples which are used for testing (following after 'horizon' examples after the training window end)", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("horizon", "Number of examples which are between the training and testing examples", 1, Integer.MAX_VALUE, 1);
        types.add(type);
        types.add(new ParameterTypeBoolean("average_performances_only", "Indicates if only performance vectors should be averaged or all types of averagable result vectors", true));
        return types;
    }
}

