/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.LastInnerOperatorCondition;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialExampleSetLearner
extends OperatorChain {
    public PartialExampleSetLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet originalExampleSet = this.getInput(ExampleSet.class);
        double fraction = this.getParameterAsDouble("fraction");
        if (fraction < 0.0 || fraction > 1.0) {
            throw new UserError((Operator)this, 207, new Object[]{fraction, "fraction", "Cannot use fractions of less than 0.0 or more than 1.0"});
        }
        SplittedExampleSet splitted = new SplittedExampleSet(originalExampleSet, fraction, this.getParameterAsInt("sampling_type"), this.getParameterAsInt("local_random_seed"));
        splitted.selectSingleSubset(0);
        IOContainer input = new IOContainer(new IOObject[]{splitted});
        input = this.getOperator(0).apply(input);
        return new IOObject[]{input.get(Model.class)};
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{Model.class});
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{Model.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble("fraction", "The fraction of examples which shall be used.", 0.0, 1.0, 0.05);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory("sampling_type", "Defines the sampling type (linear = consecutive subsets, shuffled = random subsets, stratified = random subsets with class distribution kept constant)", SplittedExampleSet.SAMPLING_NAMES, 2));
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global)", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

