/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.condition.CombinedInnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.SpecificInnerOperatorCondition;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LearningCurveOperator
extends OperatorChain {
    private double lastFraction = Double.NaN;
    private double lastPerformance = Double.NaN;
    private double lastDeviation = Double.NaN;

    public LearningCurveOperator(OperatorDescription description) {
        super(description);
        this.addValue(new Value("fraction", "The used fraction of data.."){

            public double getValue() {
                return LearningCurveOperator.this.lastFraction;
            }
        });
        this.addValue(new Value("performance", "The last performance (main criterion)."){

            public double getValue() {
                return LearningCurveOperator.this.lastPerformance;
            }
        });
        this.addValue(new Value("deviation", "The variance of the last performance (main criterion)."){

            public double getValue() {
                return LearningCurveOperator.this.lastDeviation;
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet originalExampleSet = this.getInput(ExampleSet.class);
        double stepFraction = this.getParameterAsDouble("step_fraction");
        double trainingRatio = this.getParameterAsDouble("training_ratio");
        int localSeed = this.getParameterAsInt("local_random_seed");
        SplittedExampleSet trainTestSplittedExamples = new SplittedExampleSet(originalExampleSet, trainingRatio, 1, localSeed);
        trainTestSplittedExamples.selectSingleSubset(0);
        this.lastFraction = stepFraction;
        while (this.lastFraction <= 1.0) {
            SplittedExampleSet growingTrainingSet = new SplittedExampleSet((ExampleSet)trainTestSplittedExamples, this.lastFraction, 1, localSeed);
            growingTrainingSet.selectSingleSubset(0);
            IOContainer input = new IOContainer(new IOObject[]{growingTrainingSet});
            input = this.getOperator(0).apply(input);
            trainTestSplittedExamples.selectSingleSubset(1);
            input = input.append(trainTestSplittedExamples);
            int i = 1;
            while (i < this.getNumberOfOperators()) {
                input = this.getOperator(i).apply(input);
                ++i;
            }
            PerformanceVector performance = input.remove(PerformanceVector.class);
            this.lastPerformance = performance.getMainCriterion().getAverage();
            this.lastDeviation = performance.getMainCriterion().getStandardDeviation();
            this.lastFraction += stepFraction;
            this.inApplyLoop();
        }
        return new IOObject[0];
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        CombinedInnerOperatorCondition condition = new CombinedInnerOperatorCondition();
        condition.addCondition(new SpecificInnerOperatorCondition("Training", 0, new Class[]{ExampleSet.class}, new Class[]{Model.class}));
        condition.addCondition(new SpecificInnerOperatorCondition("Testing", 1, new Class[]{ExampleSet.class, Model.class}, new Class[]{PerformanceVector.class}));
        return condition;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble("step_fraction", "The fraction of examples which would be additionally used in each step.", 0.0, 1.0, 0.05);
        type.setExpert(false);
        types.add(type);
        ParameterTypeDouble trainTestRatio = new ParameterTypeDouble("training_ratio", "The fraction of examples which shall be maximal used for training (dynamically growing), the rest is used for testing (fixed)", 0.0, 1.0, 0.05);
        trainTestRatio.setExpert(false);
        types.add(trainTestRatio);
        types.add(new ParameterTypeInt("local_random_seed", "The local random seed for random number generation (-1: use global random generator).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

