/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation;

import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.LastInnerOperatorCondition;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.operator.validation.Tools;
import edu.udo.cs.yale.tools.math.AverageVector;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratingPerformanceAverage
extends OperatorChain {
    private PerformanceCriterion lastPerformance;

    public IteratingPerformanceAverage(OperatorDescription description) {
        super(description);
        this.addValue(new Value("performance", "The last performance average (main criterion)."){

            public double getValue() {
                if (IteratingPerformanceAverage.this.lastPerformance != null) {
                    return IteratingPerformanceAverage.this.lastPerformance.getAverage();
                }
                return Double.NaN;
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        int numberOfIterations = this.getParameterAsInt("iterations");
        LinkedList<AverageVector> averageVectors = new LinkedList<AverageVector>();
        int i = 0;
        while (i < numberOfIterations) {
            IOContainer evalOutput = this.evaluate();
            Tools.handleAverages(evalOutput, averageVectors, this.getParameterAsBoolean("average_performances_only"));
            this.inApplyLoop();
            ++i;
        }
        PerformanceVector averagePerformance = Tools.getPerformanceVector(averageVectors);
        if (averagePerformance != null) {
            this.lastPerformance = averagePerformance.getMainCriterion();
        }
        IOObject[] result = new AverageVector[averageVectors.size()];
        averageVectors.toArray(result);
        return result;
    }

    private IOContainer evaluate() throws OperatorException {
        IOContainer container = this.getInput().copy();
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            container = this.getOperator(i).apply(container);
            ++i;
        }
        return container;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{PerformanceVector.class});
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 0;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("iterations", "The number of iterations.", 1, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("average_performances_only", "Indicates if only performance vectors should be averaged or all types of averagable result vectors.", true));
        return types;
    }
}

